/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.managers.ElkObjectEntityRecyclingFactory;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.AbstractElkEntityVisitor;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.Operations;

public class TaxonomyPrinter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTaxomomyToFile(Taxonomy<? extends ElkEntity> taxonomy, String fileName, boolean addHash) throws IOException {
        FileWriter fstream = new FileWriter(fileName);
        try (BufferedWriter writer = new BufferedWriter(fstream);){
            TaxonomyPrinter.dumpTaxomomy(taxonomy, writer, addHash);
        }
    }

    public static void dumpTaxomomy(Taxonomy<? extends ElkEntity> taxonomy, Writer writer, boolean addHash) throws IOException {
        writer.append("Ontology(\n");
        TaxonomyPrinter.processTaxomomy(taxonomy, writer);
        writer.append(")\n");
        if (addHash) {
            writer.append("\n# Hash code: " + TaxonomyPrinter.getHashString(taxonomy) + "\n");
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpInstanceTaxomomyToFile(InstanceTaxonomy<? extends ElkEntity, ? extends ElkEntity> taxonomy, String fileName, boolean addHash) throws IOException {
        FileWriter fstream = new FileWriter(fileName);
        try (BufferedWriter writer = new BufferedWriter(fstream);){
            TaxonomyPrinter.dumpInstanceTaxomomy(taxonomy, writer, addHash);
        }
    }

    public static void dumpInstanceTaxomomy(InstanceTaxonomy<? extends ElkEntity, ? extends ElkEntity> taxonomy, Writer writer, boolean addHash) throws IOException {
        writer.write("Ontology(\n");
        TaxonomyPrinter.processInstanceTaxomomy(taxonomy, writer);
        writer.write(")\n");
        if (addHash) {
            writer.write("\n# Hash code: " + TaxonomyPrinter.getInstanceHashString(taxonomy) + "\n");
        }
        writer.flush();
    }

    public static String getHashString(Taxonomy<? extends ElkEntity> taxonomy) {
        return Integer.toHexString(TaxonomyHasher.hash(taxonomy));
    }

    public static String getInstanceHashString(InstanceTaxonomy<? extends ElkEntity, ? extends ElkEntity> taxonomy) {
        return Integer.toHexString(InstanceTaxonomyHasher.hash(taxonomy));
    }

    protected static <T extends ElkEntity> void processTaxomomy(Taxonomy<T> taxonomy, Appendable writer) throws IOException {
        ElkObjectEntityRecyclingFactory factory = new ElkObjectEntityRecyclingFactory();
        ArrayList<ElkEntity> members = new ArrayList<ElkEntity>(taxonomy.getNodes().size() * 2);
        for (TaxonomyNode<T> node : taxonomy.getNodes()) {
            for (ElkEntity member : node) {
                if (member.getIri().equals((Object)((ElkEntity)taxonomy.getTopNode().getCanonicalMember()).getIri()) || member.getIri().equals((Object)((ElkEntity)taxonomy.getBottomNode().getCanonicalMember()).getIri())) continue;
                members.add(member);
            }
        }
        Collections.sort(members, taxonomy.getKeyProvider().getComparator());
        TaxonomyPrinter.printDeclarations(members, (ElkObject.Factory)factory, writer);
        TreeSet canonicalMembers = new TreeSet(taxonomy.getKeyProvider().getComparator());
        for (TaxonomyNode<T> node : taxonomy.getNodes()) {
            canonicalMembers.add(node.getCanonicalMember());
        }
        for (ElkEntity canonicalMember : canonicalMembers) {
            TaxonomyNode<ElkEntity> node = taxonomy.getNode(canonicalMember);
            ArrayList<ElkEntity> orderedEquivalentMembers = new ArrayList<ElkEntity>(node.size());
            for (ElkEntity member : node) {
                orderedEquivalentMembers.add(member);
            }
            Collections.sort(orderedEquivalentMembers, taxonomy.getKeyProvider().getComparator());
            TreeSet orderedSuperMembers = new TreeSet(taxonomy.getKeyProvider().getComparator());
            for (TaxonomyNode<ElkEntity> superNode : node.getDirectSuperNodes()) {
                orderedSuperMembers.add(superNode.getCanonicalMember());
            }
            TaxonomyPrinter.printMemberAxioms(canonicalMember, orderedEquivalentMembers, orderedSuperMembers, taxonomy, (ElkObject.Factory)factory, writer);
        }
    }

    protected static <T extends ElkEntity> void printDeclarations(Iterable<T> members, ElkObject.Factory factory, Appendable writer) throws IOException {
        for (ElkEntity member : members) {
            ElkDeclarationAxiom axiom = factory.getDeclarationAxiom(member);
            OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)axiom, (boolean)true);
            writer.append('\n');
        }
    }

    protected static <T extends ElkEntity, I extends ElkEntity> void printMemberAxioms(I member, List<I> equivalentMembers, SortedSet<T> directSuperMembers, Taxonomy<T> taxonomy, ElkObject.Factory factory, Appendable writer) throws IOException {
        if (equivalentMembers.size() > 1) {
            ElkAxiom axiom = (ElkAxiom)member.accept(TaxonomyPrinter.getEquivalentAxiomProvider(equivalentMembers, factory));
            OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)axiom, (boolean)true);
            writer.append('\n');
        }
        if (!member.equals(taxonomy.getBottomNode().getCanonicalMember())) {
            for (ElkEntity superMember : directSuperMembers) {
                if (superMember.equals(taxonomy.getTopNode().getCanonicalMember())) continue;
                ElkAxiom axiom = (ElkAxiom)member.accept(TaxonomyPrinter.getSubAxiomProvider(superMember, factory));
                OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)axiom, (boolean)true);
                writer.append('\n');
            }
        }
    }

    private static ElkEntityVisitor<ElkAxiom> getEquivalentAxiomProvider(final List<? extends ElkEntity> equivalent, final ElkObject.Factory factory) {
        return new AbstractElkEntityVisitor<ElkAxiom>(){

            protected ElkAxiom defaultVisit(ElkEntity entity) {
                return null;
            }

            public ElkAxiom visit(ElkClass cls) {
                return factory.getEquivalentClassesAxiom(new ArrayList(Operations.getCollection((Iterable)Operations.filter((Iterable)equivalent, ElkClass.class), (int)equivalent.size())));
            }

            public ElkAxiom visit(ElkNamedIndividual ind) {
                return factory.getSameIndividualAxiom(new ArrayList(Operations.getCollection((Iterable)Operations.filter((Iterable)equivalent, ElkNamedIndividual.class), (int)equivalent.size())));
            }

            public ElkAxiom visit(ElkObjectProperty prop) {
                return factory.getEquivalentObjectPropertiesAxiom(new ArrayList(Operations.getCollection((Iterable)Operations.filter((Iterable)equivalent, ElkObjectProperty.class), (int)equivalent.size())));
            }
        };
    }

    private static ElkEntityVisitor<ElkAxiom> getSubAxiomProvider(final ElkEntity superEntity, final ElkObject.Factory factory) {
        return new AbstractElkEntityVisitor<ElkAxiom>(){

            protected ElkAxiom defaultVisit(ElkEntity entity) {
                return null;
            }

            public ElkAxiom visit(ElkClass cls) {
                if (superEntity instanceof ElkClass) {
                    return factory.getSubClassOfAxiom((ElkClassExpression)cls, (ElkClassExpression)((ElkClass)superEntity));
                }
                return this.defaultVisit((ElkEntity)cls);
            }

            public ElkAxiom visit(ElkNamedIndividual ind) {
                if (superEntity instanceof ElkClass) {
                    return factory.getClassAssertionAxiom((ElkClassExpression)((ElkClass)superEntity), (ElkIndividual)ind);
                }
                return this.defaultVisit((ElkEntity)ind);
            }

            public ElkAxiom visit(ElkObjectProperty prop) {
                if (superEntity instanceof ElkObjectProperty) {
                    return factory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)prop, (ElkObjectPropertyExpression)((ElkObjectProperty)superEntity));
                }
                return this.defaultVisit((ElkEntity)prop);
            }
        };
    }

    protected static <T extends ElkEntity, I extends ElkEntity> void processInstanceTaxomomy(InstanceTaxonomy<T, I> taxonomy, Appendable writer) throws IOException {
        ElkObjectEntityRecyclingFactory factory = new ElkObjectEntityRecyclingFactory();
        ArrayList<ElkEntity> members = new ArrayList<ElkEntity>(taxonomy.getInstanceNodes().size() * 2);
        for (InstanceNode<T, I> node : taxonomy.getInstanceNodes()) {
            for (ElkEntity member : node) {
                members.add(member);
            }
        }
        Collections.sort(members, taxonomy.getInstanceKeyProvider().getComparator());
        TaxonomyPrinter.printDeclarations(members, (ElkObject.Factory)factory, writer);
        TaxonomyPrinter.processTaxomomy(taxonomy, writer);
        TreeSet<I> canonicalIndividuals = new TreeSet<I>(taxonomy.getInstanceKeyProvider().getComparator());
        for (InstanceNode<T, I> node : taxonomy.getInstanceNodes()) {
            canonicalIndividuals.add(node.getCanonicalMember());
        }
        for (ElkEntity individual : canonicalIndividuals) {
            InstanceNode<T, ElkEntity> node = taxonomy.getInstanceNode(individual);
            ArrayList<ElkEntity> orderedSameIndividuals = new ArrayList<ElkEntity>(node.size());
            for (ElkEntity member : node) {
                orderedSameIndividuals.add(member);
            }
            Collections.sort(orderedSameIndividuals, taxonomy.getInstanceKeyProvider().getComparator());
            TreeSet orderedTypes = new TreeSet(taxonomy.getKeyProvider().getComparator());
            for (TypeNode<T, ElkEntity> typeNode : node.getDirectTypeNodes()) {
                orderedTypes.add(typeNode.getCanonicalMember());
            }
            TaxonomyPrinter.printMemberAxioms(individual, orderedSameIndividuals, orderedTypes, taxonomy, (ElkObject.Factory)factory, writer);
        }
    }
}

