/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.NodeHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class TypeNodeHasher
implements Hasher<TypeNode<? extends ElkEntity, ? extends ElkEntity>> {
    public static TypeNodeHasher INSTANCE = new TypeNodeHasher();

    private TypeNodeHasher() {
    }

    public int hash(TypeNode<? extends ElkEntity, ? extends ElkEntity> node) {
        int n;
        int memberHash = NodeHasher.INSTANCE.hash(node);
        int subClassHash = "subClassOf".hashCode();
        for (Node node2 : node.getDirectSubNodes()) {
            subClassHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{subClassHash, NodeHasher.INSTANCE.hash(node2)});
        }
        int superClassHash = "superClassOf".hashCode();
        for (Node node3 : node.getDirectSuperNodes()) {
            superClassHash = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{superClassHash, NodeHasher.INSTANCE.hash(node3)});
        }
        int n2 = "instanceOf".hashCode();
        for (Node node4 : node.getDirectInstanceNodes()) {
            n = HashGenerator.combineMultisetHash((boolean)false, (int[])new int[]{n, NodeHasher.INSTANCE.hash(node4)});
        }
        return HashGenerator.combineListHash((int[])new int[]{memberHash, subClassHash, superClassHash, n});
    }
}

