/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyEqualator;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractDistinctBottomTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractUpdateableGenericTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableNodeStore;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTaxonomyTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeFactory;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeFactory;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.util.collections.LazySetUnion;

public abstract class AbstractUpdateableGenericInstanceTaxonomy<T extends ElkEntity, I extends ElkEntity, TN extends GenericTypeNode<T, I, TN, IN>, IN extends GenericInstanceNode<T, I, TN, IN>, UTN extends UpdateableTaxonomyTypeNode<T, I, TN, IN, UTN, UIN>, UIN extends UpdateableInstanceNode<T, I, TN, IN, UTN, UIN>>
extends AbstractUpdateableGenericTaxonomy<T, TN, UTN>
implements UpdateableInstanceTaxonomy<T, I> {
    private final NodeFactory<I, UIN> instanceNodeFactory_;
    protected final UpdateableNodeStore<I, UIN> instanceNodeStore_;
    protected final List<InstanceTaxonomy.Listener<T, I>> instanceListeners_;

    public AbstractUpdateableGenericInstanceTaxonomy(UpdateableNodeStore<T, UTN> typeNodeStore, TaxonomyNodeFactory<T, UTN, AbstractDistinctBottomTaxonomy<T, TN, UTN>> typeNodeFactory, UpdateableNodeStore<I, UIN> instanceNodeStore, final TaxonomyNodeFactory<I, UIN, InstanceTaxonomy<T, I>> instanceNodeFactory, T topMember) {
        super(typeNodeStore, typeNodeFactory, topMember);
        this.instanceNodeStore_ = instanceNodeStore;
        this.instanceNodeFactory_ = new NodeFactory<I, UIN>(){

            @Override
            public UIN createNode(Iterable<? extends I> members, int size) {
                return (UpdateableInstanceNode)instanceNodeFactory.createNode(members, size, AbstractUpdateableGenericInstanceTaxonomy.this);
            }
        };
        this.instanceListeners_ = new ArrayList<InstanceTaxonomy.Listener<T, I>>();
    }

    @Override
    public ComparatorKeyProvider<? super I> getInstanceKeyProvider() {
        return this.instanceNodeStore_.getKeyProvider();
    }

    @Override
    public InstanceNode<T, I> getInstanceNode(I elkEntity) {
        return (InstanceNode)this.instanceNodeStore_.getNode(elkEntity);
    }

    @Override
    public Set<? extends InstanceNode<T, I>> getInstanceNodes() {
        return this.instanceNodeStore_.getNodes();
    }

    @Override
    public TypeNode<T, I> getNode(T elkEntity) {
        TaxonomyNode result = (TypeNode)this.nodeStore_.getNode(elkEntity);
        if (result == null && this.getBottomNode().contains(elkEntity)) {
            result = this.getBottomNode();
        }
        return result;
    }

    @Override
    public Set<? extends TypeNode<T, I>> getNodes() {
        return new LazySetUnion(this.nodeStore_.getNodes(), Collections.singleton(this.getBottomNode()));
    }

    @Override
    public abstract TN getBottomNode();

    @Override
    public InstanceNode<T, I> getCreateInstanceNode(Collection<? extends I> instances) {
        return (InstanceNode)this.instanceNodeStore_.getCreateNode(instances, instances.size(), this.instanceNodeFactory_);
    }

    @Override
    public boolean setCreateDirectTypes(InstanceNode<T, I> instanceNode, Iterable<? extends Collection<? extends T>> typeSets) {
        UIN node = this.toInternalInstanceNode(instanceNode);
        boolean isTypeSetsEmpty = true;
        for (Collection<T> collection : typeSets) {
            UpdateableTaxonomyTypeNode superNode = (UpdateableTaxonomyTypeNode)this.getCreateNode(collection);
            isTypeSetsEmpty = false;
            this.addDirectType(superNode, node);
        }
        if (node.trySetAllParentsAssigned(true)) {
            if (!isTypeSetsEmpty) {
                this.fireDirectTypeAssignment(instanceNode, instanceNode.getDirectTypeNodes());
            }
            return true;
        }
        return false;
    }

    private void addDirectType(UTN typeNode, UIN instanceNode) {
        instanceNode.addDirectTypeNode(typeNode);
        typeNode.addDirectInstanceNode(instanceNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDirectTypes(InstanceNode<T, I> instanceNode) {
        UIN node = this.toInternalInstanceNode(instanceNode);
        if (!node.trySetAllParentsAssigned(false)) {
            return false;
        }
        ArrayList directTypes = new ArrayList();
        Object object = node;
        synchronized (object) {
            directTypes.addAll(node.getDirectNonBottomTypeNodes());
            for (UpdateableTaxonomyTypeNode typeNode : directTypes) {
                node.removeDirectTypeNode((UpdateableTaxonomyTypeNode)typeNode);
            }
        }
        object = directTypes.iterator();
        while (object.hasNext()) {
            UpdateableTaxonomyTypeNode typeNode;
            UpdateableTaxonomyTypeNode updateableTaxonomyTypeNode = typeNode = (UpdateableTaxonomyTypeNode)object.next();
            synchronized (updateableTaxonomyTypeNode) {
                typeNode.removeDirectInstanceNode(node);
            }
        }
        this.fireDirectTypeRemoval(instanceNode, directTypes);
        return true;
    }

    @Override
    public boolean removeInstanceNode(I instance) {
        return this.instanceNodeStore_.removeNode(instance);
    }

    protected UIN toInternalInstanceNode(InstanceNode<T, I> node) {
        if (node.getTaxonomy() != this) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + node);
        }
        try {
            return (UIN)((UpdateableInstanceNode)node);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + node);
        }
    }

    @Override
    public int hashCode() {
        return InstanceTaxonomyHasher.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Taxonomy)) {
            return false;
        }
        try {
            return InstanceTaxonomyEqualator.equals(this, (Taxonomy)obj);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean addInstanceListener(NodeStore.Listener<I> listener) {
        return this.instanceNodeStore_.addListener(listener);
    }

    @Override
    public boolean removeInstanceListener(NodeStore.Listener<I> listener) {
        return this.instanceNodeStore_.removeListener(listener);
    }

    @Override
    public boolean addInstanceListener(InstanceTaxonomy.Listener<T, I> listener) {
        return this.instanceListeners_.add(listener);
    }

    @Override
    public boolean removeInstanceListener(InstanceTaxonomy.Listener<T, I> listener) {
        return this.instanceListeners_.remove(listener);
    }

    protected void fireDirectTypeAssignment(InstanceNode<T, I> instanceNode, Collection<? extends TypeNode<T, I>> typeNodes) {
        for (InstanceTaxonomy.Listener<T, I> listener : this.instanceListeners_) {
            listener.directTypeNodesAppeared(instanceNode);
            for (TypeNode<T, I> typeNode : typeNodes) {
                listener.directInstanceNodesAppeared(typeNode);
            }
        }
    }

    protected void fireDirectTypeRemoval(InstanceNode<T, I> instanceNode, Collection<? extends TypeNode<T, I>> typeNodes) {
        for (InstanceTaxonomy.Listener<T, I> listener : this.instanceListeners_) {
            listener.directTypeNodesDisappeared(instanceNode);
            for (TypeNode<T, I> typeNode : typeNodes) {
                listener.directInstanceNodesDisappeared(typeNode);
            }
        }
    }
}

