/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractDistinctBottomTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.IndividualNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.NonBottomGenericTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTaxonomyTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NonBottomGenericTypeNode<T extends ElkEntity, I extends ElkEntity, TN extends GenericTypeNode<T, I, TN, IN>, IN extends GenericInstanceNode<T, I, TN, IN>, UTN extends UpdateableTaxonomyTypeNode<T, I, TN, IN, UTN, UIN>, UIN extends UpdateableInstanceNode<T, I, TN, IN, UTN, UIN>>
extends NonBottomGenericTaxonomyNode<T, TN, UTN>
implements GenericTypeNode<T, I, TN, IN>,
UpdateableTaxonomyTypeNode<T, I, TN, IN, UTN, UIN> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(NonBottomGenericTypeNode.class);
    private final Set<UIN> directInstanceNodes_ = new ArrayHashSet();

    public NonBottomGenericTypeNode(AbstractDistinctBottomTaxonomy<T, TN, UTN> taxonomy, Iterable<? extends T> members, int size) {
        super(taxonomy, members, size);
    }

    @Override
    public synchronized void addDirectInstanceNode(UIN instanceNode) {
        LOGGER_.trace("{}: new direct instance-node {}", (Object)this, instanceNode);
        this.directInstanceNodes_.add(instanceNode);
    }

    @Override
    public synchronized void removeDirectInstanceNode(UIN instanceNode) {
        LOGGER_.trace("{}: direct instance node removed {}", (Object)this, instanceNode);
        this.directInstanceNodes_.remove(instanceNode);
    }

    @Override
    public Set<? extends IN> getDirectInstanceNodes() {
        return Collections.unmodifiableSet(this.toInstanceNodes(this.directInstanceNodes_));
    }

    @Override
    public Set<? extends IN> getAllInstanceNodes() {
        return TaxonomyNodeUtils.getAllInstanceNodes(this);
    }

    protected abstract Set<? extends IN> toInstanceNodes(Set<? extends UIN> var1);

    public static class Projection<T extends ElkEntity, I extends ElkEntity>
    extends NonBottomGenericTypeNode<T, I, GenericTypeNode.Projection<T, I>, GenericInstanceNode.Projection<T, I>, Projection<T, I>, IndividualNode.Projection2<T, I>>
    implements GenericTypeNode.Projection<T, I> {
        public Projection(AbstractDistinctBottomTaxonomy<T, GenericTypeNode.Projection<T, I>, Projection<T, I>> taxonomy, Iterable<? extends T> members, int size) {
            super(taxonomy, members, size);
        }

        @Override
        protected Set<? extends GenericInstanceNode.Projection<T, I>> toInstanceNodes(Set<? extends IndividualNode.Projection2<T, I>> nodes) {
            return nodes;
        }
    }
}

