/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.elk.reasoner.taxonomy.impl.SimpleNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableNode;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUpdateableNode<T>
extends SimpleNode<T>
implements UpdateableNode<T> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(SimpleUpdateableNode.class);
    private final AtomicBoolean areAllParentsAssigned_ = new AtomicBoolean(false);

    public SimpleUpdateableNode(Iterable<? extends T> members, int size, ComparatorKeyProvider<? super T> keyProvider) {
        super(members, size, keyProvider);
    }

    public SimpleUpdateableNode(ComparatorKeyProvider<T> comparatorKeyProvider) {
        super(comparatorKeyProvider);
    }

    @Override
    public boolean trySetAllParentsAssigned(boolean modified) {
        boolean result = this.areAllParentsAssigned_.compareAndSet(!modified, modified);
        if (result && LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("node " + this + ": set " + (modified ? "modified" : "not modifiled"));
        }
        return result;
    }

    @Override
    public boolean areAllParentsAssigned() {
        return this.areAllParentsAssigned_.get();
    }

    @Override
    public void setMembers(Iterable<? extends T> members) {
        this.members_.clear();
        for (T elkClass : members) {
            this.members_.add(elkClass);
        }
        Collections.sort(this.members_, this.getKeyProvider().getComparator());
        LOGGER_.trace("updated members of {}", (Object)this);
    }
}

