/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractNodeStore;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableNodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeFactory;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class SynchronizedNodeStore<T, N extends UpdateableNode<T>>
extends AbstractNodeStore<T, N>
implements UpdateableNodeStore<T, N> {
    private final ComparatorKeyProvider<? super T> keyProvider_;
    private final Map<Object, N> nodeLookup_;
    private final Set<N> allNodes_;

    public SynchronizedNodeStore(int capacity, ComparatorKeyProvider<? super T> keyProvider) {
        this.keyProvider_ = keyProvider;
        this.nodeLookup_ = new ArrayHashMap(capacity);
        this.allNodes_ = new ArrayHashSet(capacity);
    }

    public SynchronizedNodeStore(ComparatorKeyProvider<? super T> keyProvider) {
        this(127, keyProvider);
    }

    @Override
    public synchronized N getNode(T member) {
        return (N)((UpdateableNode)this.nodeLookup_.get(this.keyProvider_.getKey(member)));
    }

    @Override
    public synchronized Set<N> getNodes() {
        return Collections.unmodifiableSet(this.allNodes_);
    }

    @Override
    public ComparatorKeyProvider<? super T> getKeyProvider() {
        return this.keyProvider_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized N getCreateNode(Iterable<? extends T> members, int size, NodeFactory<T, N> factory) {
        Node previous;
        for (T member : members) {
            previous = this.getNode((Object)member);
            if (previous == null) continue;
            Node node = previous;
            synchronized (node) {
                if (previous.size() >= size) {
                    return (N)previous;
                }
                previous.setMembers(members);
            }
            for (Object m : members) {
                this.nodeLookup_.put(this.keyProvider_.getKey(m), previous);
            }
            this.fireMemberForNodeAppeared(previous);
            return (N)previous;
        }
        UpdateableNode node = (UpdateableNode)factory.createNode(members, size);
        Object canonicalMember = node.getCanonicalMember();
        previous = this.nodeLookup_.put(this.keyProvider_.getKey(canonicalMember), node);
        if (previous != null) {
            return (N)previous;
        }
        this.allNodes_.add(node);
        for (Object member : node) {
            if (member == canonicalMember) continue;
            this.nodeLookup_.put(this.keyProvider_.getKey(member), node);
        }
        this.fireMemberForNodeAppeared(node);
        return (N)node;
    }

    @Override
    public synchronized boolean removeNode(T member) {
        Node node = this.getNode((Object)member);
        if (node == null) {
            return false;
        }
        boolean changed = false;
        if (this.allNodes_.remove(node)) {
            for (Object m : node) {
                changed |= this.nodeLookup_.remove(this.keyProvider_.getKey(m)) != null;
            }
            this.fireMemberForNodeDisappeared(node);
        }
        return changed;
    }
}

