/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.reasoner.tracing.Conclusion;
import org.semanticweb.elk.reasoner.tracing.ModifiableTracingProof;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.TracingInferenceConclusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiableTracingProofImpl<I extends TracingInference>
implements ModifiableTracingProof<I> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ModifiableTracingProofImpl.class);
    private final Multimap<Conclusion, I> inferenceMap_ = ArrayListMultimap.create();

    public void produce(I inference) {
        LOGGER_.trace("{}: inference produced", inference);
        this.inferenceMap_.put((Object)new TracingInferenceConclusion((TracingInference)inference), inference);
    }

    public void clear() {
        this.inferenceMap_.clear();
    }

    public Collection<? extends I> getInferences(Object conclusion) {
        if (conclusion instanceof Conclusion) {
            return this.inferenceMap_.get((Object)((Conclusion)conclusion));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<? extends Conclusion> getAllConclusions() {
        return this.inferenceMap_.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Conclusion key : this.inferenceMap_.keySet()) {
            for (TracingInference inf : this.inferenceMap_.get((Object)key)) {
                sb.append(inf.toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

