/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing.factories;

import org.liveontologies.puli.Producer;
import org.semanticweb.elk.Reference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.saturation.ExtendedContext;
import org.semanticweb.elk.reasoner.saturation.MainContextFactory;
import org.semanticweb.elk.reasoner.saturation.MapSaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionInsertionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.DummyClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.TracingRuleApplicationClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInferenceConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.inferences.DummyClassInferenceVisitor;
import org.semanticweb.elk.reasoner.saturation.inferences.SubContextInitializationNoPremises;
import org.semanticweb.elk.reasoner.saturation.rules.AllInferencesRuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleStatistics;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.factories.AbstractRuleApplicationFactory;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class ContextTracingRuleApplicationFactory
extends AbstractRuleApplicationFactory<ExtendedContext, RuleApplicationInput> {
    private final SaturationState<?> mainSaturationState_;
    private final Producer<ClassInference> inferenceProducer_;

    public ContextTracingRuleApplicationFactory(InterruptMonitor interrupter, SaturationState<?> mainSaturationState, Producer<ClassInference> inferenceProducer) {
        super(interrupter, new MapSaturationState<ExtendedContext>(mainSaturationState.getOntologyIndex(), new MainContextFactory()));
        this.mainSaturationState_ = mainSaturationState;
        this.inferenceProducer_ = inferenceProducer;
    }

    @Override
    protected RuleVisitor<?> getRuleVisitor(RuleStatistics statistics) {
        return new AllInferencesRuleVisitor();
    }

    @Override
    protected ClassInference.Visitor<Boolean> getInferenceProcessor(Reference<Context> activeContext, RuleVisitor<?> ruleVisitor, final SaturationStateWriter<? extends ExtendedContext> localWriter, SaturationStatistics localStatistics) {
        return SaturationUtils.compose(new InferenceProducingVisitor(), new ClassInferenceConclusionVisitor<Boolean>(SaturationUtils.compose(new ClassConclusionInsertionVisitor(activeContext, localWriter), new TracingRuleApplicationClassConclusionVisitor(this.mainSaturationState_, activeContext, ruleVisitor, localWriter), new DummyClassConclusionVisitor<Boolean>(){

            @Override
            protected Boolean defaultVisit(ClassConclusion conclusion) {
                return true;
            }

            @Override
            public Boolean visit(ContextInitialization conclusion) {
                IndexedContextRoot root = conclusion.getTraceRoot();
                Object mainContext = ContextTracingRuleApplicationFactory.this.mainSaturationState_.getContext(root);
                for (IndexedObjectProperty subRoot : mainContext.getSubContextPremisesByObjectProperty().keySet()) {
                    localWriter.produce(new SubContextInitializationNoPremises(root, subRoot));
                }
                return true;
            }
        })));
    }

    private class InferenceProducingVisitor
    extends DummyClassInferenceVisitor<Boolean> {
        private InferenceProducingVisitor() {
        }

        @Override
        protected Boolean defaultVisit(ClassInference inference) {
            ContextTracingRuleApplicationFactory.this.inferenceProducer_.produce((Object)inference);
            return true;
        }
    }
}

