/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing.factories;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.liveontologies.puli.Producer;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationFactory;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.tracing.ModifiableTracingProofImpl;
import org.semanticweb.elk.reasoner.tracing.TraceState;
import org.semanticweb.elk.reasoner.tracing.factories.ClassInferenceBlockingFilter;
import org.semanticweb.elk.reasoner.tracing.factories.ContextTracingRuleApplicationFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.Processor;
import org.semanticweb.elk.util.concurrent.computation.ProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleContextTracingFactory
implements ProcessorFactory<Engine> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(SingleContextTracingFactory.class);
    private final TraceState tracingState_;
    private final ConcurrentMap<IndexedContextRoot, Queue<ClassInference>> tracedInferences_;
    private final ClassExpressionSaturationFactory<SaturationJob<IndexedContextRoot>> saturationFactory_;

    public SingleContextTracingFactory(TraceState tracingState, InterruptMonitor interrupter, SaturationState<?> saturationState, int maxWorkers) {
        this.tracingState_ = tracingState;
        this.saturationFactory_ = new ClassExpressionSaturationFactory<SaturationJob<IndexedContextRoot>>(new ContextTracingRuleApplicationFactory(interrupter, saturationState, new ThisClassInferenceProducer()), maxWorkers, new ThisClassExpressionSaturationListener());
        this.tracedInferences_ = new ConcurrentHashMap<IndexedContextRoot, Queue<ClassInference>>();
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void finish() {
        this.saturationFactory_.finish();
    }

    public boolean isInterrupted() {
        return this.saturationFactory_.isInterrupted();
    }

    public void printStatistics() {
        this.saturationFactory_.printStatistics();
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.saturationFactory_.getRuleAndConclusionStatistics();
    }

    private class ThisClassInferenceProducer
    implements Producer<ClassInference> {
        private ThisClassInferenceProducer() {
        }

        public void produce(ClassInference inference) {
            IndexedContextRoot originRoot = inference.getTraceRoot();
            Queue<ClassInference> inferencesByOrigin = (ConcurrentLinkedQueue<ClassInference>)SingleContextTracingFactory.this.tracedInferences_.get(originRoot);
            if (inferencesByOrigin == null) {
                inferencesByOrigin = new ConcurrentLinkedQueue<ClassInference>();
                Queue previous = SingleContextTracingFactory.this.tracedInferences_.putIfAbsent(originRoot, inferencesByOrigin);
                if (previous != null) {
                    inferencesByOrigin = previous;
                }
            }
            inferencesByOrigin.add(inference);
        }
    }

    private class ThisClassExpressionSaturationListener
    implements ClassExpressionSaturationListener<SaturationJob<IndexedContextRoot>> {
        private ThisClassExpressionSaturationListener() {
        }

        public void notifyFinished(SaturationJob<IndexedContextRoot> job) throws InterruptedException {
            IndexedContextRoot root = (IndexedContextRoot)job.getInput();
            LOGGER_.trace("{}: job finished", job);
            ModifiableTracingProofImpl<ClassInference> proof = new ModifiableTracingProofImpl<ClassInference>();
            ClassInferenceBlockingFilter filter = new ClassInferenceBlockingFilter(proof);
            for (ClassInference inference : (Queue)SingleContextTracingFactory.this.tracedInferences_.get(root)) {
                filter.produce(inference);
            }
            SingleContextTracingFactory.this.tracingState_.getTracingListener().notifyJobFinished((IndexedContextRoot)job.getInput(), proof);
        }
    }

    public class Engine
    implements Processor {
        private final ClassExpressionSaturationFactory.Engine saturationEngine_;

        public Engine() {
            this.saturationEngine_ = SingleContextTracingFactory.this.saturationFactory_.getEngine();
        }

        public void process() throws InterruptedException {
            while (true) {
                if (SingleContextTracingFactory.this.isInterrupted()) {
                    return;
                }
                this.saturationEngine_.process();
                IndexedContextRoot root = SingleContextTracingFactory.this.tracingState_.pollToTrace();
                if (root == null) break;
                this.saturationEngine_.submit(new SaturationJob<IndexedContextRoot>(root));
            }
        }

        public void finish() {
            this.saturationEngine_.finish();
        }
    }
}

