/*-
 * #%L
 * ELK Utilities Collections
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2011 - 2017 Department of Computer Science, University of Oxford
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.semanticweb.elk.util.collections;

import java.util.Iterator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public abstract class AbstractEvictor<E> implements Evictor<E> {

	@Override
	public Iterator<E> evict() {
		return evict(Predicates.<E> alwaysFalse());
	}

	@Override
	public Iterator<E> addAndEvict(final E element) {
		return addAndEvict(element, Predicates.<E> alwaysFalse());
	}

	@Override
	public Iterator<E> addAndEvict(final E element, final Predicate<E> retain) {
		add(element);
		return evict(retain);
	}

	protected Object stats = null;

	@Override
	public Object getStats() {
		return stats;
	}

}
