/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.importer.rf1;

import au.csiro.ontology.Ontology;
import au.csiro.ontology.importer.BaseImporter;
import au.csiro.ontology.importer.rf1.ConceptRow;
import au.csiro.ontology.importer.rf1.RelationshipRow;
import au.csiro.ontology.importer.rf1.VersionRows;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Conjunction;
import au.csiro.ontology.model.Existential;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Role;
import au.csiro.ontology.model.RoleInclusion;
import au.csiro.ontology.util.IProgressMonitor;
import au.csiro.ontology.util.SnomedMetadata;
import au.csiro.ontology.util.Statistics;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RF1Importer
extends BaseImporter {
    protected final InputStream conceptsFile;
    protected final InputStream relationshipsFile;
    protected final String version;
    protected SnomedMetadata metadata = SnomedMetadata.INSTANCE;
    protected final List<String> problems = new ArrayList<String>();
    protected final Map<String, String> primitive = new HashMap<String, String>();
    protected final Map<String, Set<String>> parents = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> children = new HashMap<String, Set<String>>();
    protected final Map<String, List<String[]>> rels = new HashMap<String, List<String[]>>();
    protected final Map<String, Map<String, String>> roles = new HashMap<String, Map<String, String>>();

    public RF1Importer(InputStream conceptsFile, InputStream relationshipsFile, String version) {
        this.conceptsFile = conceptsFile;
        this.relationshipsFile = relationshipsFile;
        this.version = version;
    }

    @Override
    public Iterator<Ontology> getOntologyVersions(IProgressMonitor monitor) {
        return new OntologyInterator(monitor);
    }

    protected void populateParent(String src, String tgt) {
        Set<String> prs = this.parents.get(src);
        if (prs == null) {
            prs = new TreeSet<String>();
            this.parents.put(src, prs);
        }
        prs.add(tgt);
    }

    protected void populateChildren(String src, String tgt) {
        Set<String> prs = this.children.get(src);
        if (prs == null) {
            prs = new TreeSet<String>();
            this.children.put(src, prs);
        }
        prs.add(tgt);
    }

    protected void populateRels(String src, String role, String tgt, String group) {
        List<String[]> val = this.rels.get(src);
        if (val == null) {
            val = new ArrayList<String[]>();
            this.rels.put(src, val);
        }
        val.add(new String[]{role, tgt, group});
    }

    protected void populateRoles(Set<String> roles, String parentSCTID) {
        for (String role : roles) {
            String ri;
            Set<String> cs = this.children.get(role);
            if (cs != null) {
                this.populateRoles(cs, role);
            }
            if ((ri = (String)this.metadata.getRightIdentityIds().get(role)) != null) {
                this.populateRoleDef(role, ri, parentSCTID);
                continue;
            }
            this.populateRoleDef(role, "", parentSCTID);
        }
    }

    protected void populateRoleDef(String code, String rightId, String parentRole) {
        Map<String, String> vals = this.roles.get(code);
        if (vals == null) {
            vals = new HashMap<String, String>();
            this.roles.put(code, vals);
        }
        vals.put("rightID", rightId);
        vals.put("parentrole", parentRole);
    }

    protected Set<Set<RoleValuePair>> groupRoles(List<String[]> groups) {
        HashMap<String, HashSet<RoleValuePair>> roleGroups = new HashMap<String, HashSet<RoleValuePair>>();
        for (String[] group : groups) {
            String roleGroup = group[2];
            HashSet<RoleValuePair> lrvp = (HashSet<RoleValuePair>)roleGroups.get(roleGroup);
            if (lrvp == null) {
                lrvp = new HashSet<RoleValuePair>();
                roleGroups.put(group[2], lrvp);
            }
            lrvp.add(new RoleValuePair(group[0], group[1]));
        }
        HashSet<Set<RoleValuePair>> res = new HashSet<Set<RoleValuePair>>();
        for (String roleGroup : roleGroups.keySet()) {
            Set val = (Set)roleGroups.get(roleGroup);
            if ("0".equals(roleGroup)) {
                for (RoleValuePair rvp : val) {
                    HashSet<RoleValuePair> sin = new HashSet<RoleValuePair>();
                    sin.add(rvp);
                    res.add(sin);
                }
                continue;
            }
            HashSet<RoleValuePair> item = new HashSet<RoleValuePair>();
            for (RoleValuePair trvp : val) {
                item.add(trvp);
            }
            res.add(item);
        }
        return res;
    }

    public void clear() {
        this.problems.clear();
        this.primitive.clear();
        this.parents.clear();
        this.children.clear();
        this.rels.clear();
        this.roles.clear();
    }

    @Override
    public List<String> getProblems() {
        return this.problems;
    }

    public boolean usesConcreteDomains() {
        return false;
    }

    public VersionRows extractVersionRows() {
        ArrayList<ConceptRow> crs = new ArrayList<ConceptRow>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.conceptsFile));
            String line = br.readLine();
            while (null != (line = br.readLine())) {
                if ((line = new String(line.getBytes(), "UTF8")).trim().length() < 1) continue;
                int idx1 = line.indexOf(9);
                int idx2 = line.indexOf(9, idx1 + 1);
                int idx3 = line.indexOf(9, idx2 + 1);
                int idx4 = line.indexOf(9, idx3 + 1);
                int idx5 = line.indexOf(9, idx4 + 1);
                if (idx1 < 0 || idx2 < 0 || idx3 < 0 || idx4 < 0 || idx5 < 0) {
                    br.close();
                    throw new RuntimeException("Concepts: Mis-formatted line, expected at least 6 tab-separated fields, got: " + line);
                }
                String conceptId = line.substring(0, idx1);
                String conceptStatus = line.substring(idx1 + 1, idx2);
                String fullySpecifiedName = line.substring(idx2 + 1, idx3);
                String ctv3Id = line.substring(idx3 + 1, idx4);
                String snomedId = line.substring(idx4 + 1, idx5);
                String isPrimitive = line.substring(idx5 + 1);
                crs.add(new ConceptRow(conceptId, conceptStatus, fullySpecifiedName, ctv3Id, snomedId, isPrimitive));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        ArrayList<RelationshipRow> rrs = new ArrayList<RelationshipRow>();
        try {
            br = new BufferedReader(new InputStreamReader(this.relationshipsFile));
            String line = br.readLine();
            while (null != (line = br.readLine())) {
                if (line.trim().length() < 1) continue;
                int idx1 = line.indexOf(9);
                int idx2 = line.indexOf(9, idx1 + 1);
                int idx3 = line.indexOf(9, idx2 + 1);
                int idx4 = line.indexOf(9, idx3 + 1);
                int idx5 = line.indexOf(9, idx4 + 1);
                int idx6 = line.indexOf(9, idx5 + 1);
                if (idx1 < 0 || idx2 < 0 || idx3 < 0 || idx4 < 0 || idx5 < 0 || idx6 < 0) {
                    br.close();
                    throw new RuntimeException("Concepts: Mis-formatted line, expected 7 tab-separated fields, got: " + line);
                }
                String relationshipId = line.substring(0, idx1);
                String conceptId1 = line.substring(idx1 + 1, idx2);
                String relationshipType = line.substring(idx2 + 1, idx3);
                String conceptId2 = line.substring(idx3 + 1, idx4);
                String characteristicType = line.substring(idx4 + 1, idx5);
                String refinability = line.substring(idx5 + 1, idx6);
                String relationshipGroup = line.substring(idx6 + 1);
                rrs.add(new RelationshipRow(relationshipId, conceptId1, relationshipType, conceptId2, characteristicType, refinability, relationshipGroup));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        VersionRows vr = new VersionRows(this.version);
        vr.getConceptRows().addAll(crs);
        vr.getRelationshipRows().addAll(rrs);
        return vr;
    }

    public SnomedMetadata getMetadata() {
        return this.metadata;
    }

    protected class RoleValuePair {
        String role;
        String value;

        RoleValuePair(String role, String value) {
            this.role = role;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RoleValuePair other = (RoleValuePair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        private RF1Importer getOuterType() {
            return RF1Importer.this;
        }
    }

    class OntologyInterator
    implements Iterator<Ontology> {
        private boolean accessed = false;
        private IProgressMonitor monitor;

        public OntologyInterator(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public boolean hasNext() {
            return !this.accessed;
        }

        @Override
        public Ontology next() {
            long start = System.currentTimeMillis();
            this.monitor.taskStarted("Loading axioms");
            VersionRows vr = RF1Importer.this.extractVersionRows();
            ArrayList<Object> axioms = new ArrayList<Object>();
            for (ConceptRow cr : vr.getConceptRows()) {
                if ("CONCEPTID".equals(cr.getConceptId()) || !"0".equals(cr.getConceptStatus())) continue;
                RF1Importer.this.primitive.put(cr.getConceptId(), cr.getIsPrimitive());
            }
            for (RelationshipRow rr : vr.getRelationshipRows()) {
                if ("RELATIONSHIPID".equals(rr.getRelationshipId()) || !"0".equals(rr.getCharacteristicType())) continue;
                if (RF1Importer.this.metadata.getIsAId().equals(rr.getRelationshipType())) {
                    RF1Importer.this.populateParent(rr.getConceptId1(), rr.getConceptId2());
                    RF1Importer.this.populateChildren(rr.getConceptId2(), rr.getConceptId1());
                    continue;
                }
                RF1Importer.this.populateRels(rr.getConceptId1(), rr.getRelationshipType(), rr.getConceptId2(), rr.getRelationshipGroup());
            }
            Set<String> conceptModelChildren = RF1Importer.this.children.get(RF1Importer.this.metadata.getConceptModelAttId());
            if (conceptModelChildren != null) {
                RF1Importer.this.populateRoles(conceptModelChildren, "");
            }
            for (String r1 : RF1Importer.this.roles.keySet()) {
                String rightId;
                String parentRole = RF1Importer.this.roles.get(r1).get("parentrole");
                if (!"".equals(parentRole)) {
                    axioms.add(new RoleInclusion((Role)new NamedRole(r1), (Role)new NamedRole(parentRole)));
                }
                if ("".equals(rightId = RF1Importer.this.roles.get(r1).get("rightID"))) continue;
                axioms.add(new RoleInclusion(new Role[]{new NamedRole(r1), new NamedRole(rightId)}, (Role)new NamedRole(r1)));
            }
            for (String c1 : RF1Importer.this.primitive.keySet()) {
                int numElems;
                if (RF1Importer.this.roles.get(c1) != null) continue;
                Set<String> prs = RF1Importer.this.parents.get(c1);
                int numParents = prs != null ? prs.size() : 0;
                List<String[]> relsVal = RF1Importer.this.rels.get(c1);
                int numRels = 0;
                if (relsVal != null) {
                    numRels = 1;
                }
                if ((numElems = numParents + numRels) == 0) continue;
                if (numElems == 1 && prs != null && !prs.isEmpty()) {
                    axioms.add(new ConceptInclusion((Concept)new NamedConcept(c1), (Concept)new NamedConcept(prs.iterator().next())));
                    continue;
                }
                ArrayList<Object> conjs = new ArrayList<Object>();
                if (prs != null) {
                    for (String string : prs) {
                        conjs.add(new NamedConcept(string));
                    }
                }
                if (relsVal != null) {
                    for (Set set : RF1Importer.this.groupRoles(relsVal)) {
                        if (set.size() > 1) {
                            ArrayList<Existential> innerConjs = new ArrayList<Existential>();
                            for (RoleValuePair rv : set) {
                                NamedRole role = new NamedRole(rv.role);
                                NamedConcept filler = new NamedConcept(rv.value);
                                Existential exis = new Existential((Role)role, (Concept)filler);
                                innerConjs.add(exis);
                            }
                            conjs.add(new Existential((Role)new NamedRole("RoleGroup"), (Concept)new Conjunction(innerConjs)));
                            continue;
                        }
                        RoleValuePair first = (RoleValuePair)set.iterator().next();
                        NamedRole role = new NamedRole(first.role);
                        NamedConcept filler = new NamedConcept(first.value);
                        Existential exis = new Existential((Role)role, (Concept)filler);
                        if (RF1Importer.this.metadata.getNeverGroupedIds().contains(first.role)) {
                            conjs.add(exis);
                            continue;
                        }
                        conjs.add(new Existential((Role)new NamedRole("RoleGroup"), (Concept)exis));
                    }
                }
                axioms.add(new ConceptInclusion((Concept)new NamedConcept(c1), (Concept)new Conjunction(conjs)));
                if (!RF1Importer.this.primitive.get(c1).equals("0")) continue;
                axioms.add(new ConceptInclusion((Concept)new Conjunction(conjs), (Concept)new NamedConcept(c1)));
            }
            Statistics.INSTANCE.setTime("rf1 loading", System.currentTimeMillis() - start);
            this.accessed = true;
            return new Ontology("snomed", vr.getVersionName(), axioms, null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

