/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.importer.rf2;

import au.csiro.ontology.Ontology;
import au.csiro.ontology.importer.BaseImporter;
import au.csiro.ontology.importer.ImportException;
import au.csiro.ontology.importer.owl.OWLImporter;
import au.csiro.ontology.importer.rf2.ConceptRow;
import au.csiro.ontology.importer.rf2.IRefsetFactory;
import au.csiro.ontology.importer.rf2.RefsetImporter;
import au.csiro.ontology.importer.rf2.RelationshipRow;
import au.csiro.ontology.importer.rf2.VersionRows;
import au.csiro.ontology.input.Input;
import au.csiro.ontology.input.ModuleInfo;
import au.csiro.ontology.input.RF2Input;
import au.csiro.ontology.input.Version;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Conjunction;
import au.csiro.ontology.model.Datatype;
import au.csiro.ontology.model.DecimalLiteral;
import au.csiro.ontology.model.Existential;
import au.csiro.ontology.model.Feature;
import au.csiro.ontology.model.FunctionalFeature;
import au.csiro.ontology.model.IntegerLiteral;
import au.csiro.ontology.model.Literal;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.model.NamedFeature;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Operator;
import au.csiro.ontology.model.Role;
import au.csiro.ontology.model.RoleInclusion;
import au.csiro.ontology.snomed.refset.rf2.IModuleDependencyRefset;
import au.csiro.ontology.snomed.refset.rf2.ModuleDependency;
import au.csiro.ontology.snomed.refset.rf2.RefsetRow;
import au.csiro.ontology.util.IProgressMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RF2Importer
extends BaseImporter {
    protected static final OWLDocumentFormat FUNCTIONAL_SYNTAX_DOCUMENT_FORMAT = new FunctionalSyntaxDocumentFormat();
    private static final Logger log = LoggerFactory.getLogger(RF2Importer.class);
    protected final List<String> problems = new ArrayList<String>();
    protected final Queue<RF2Input> inputs = new LinkedList<RF2Input>();

    public RF2Importer(RF2Input input) {
        this.inputs.add(input);
    }

    public RF2Importer(Collection<Input> inputs) {
        for (Input in : inputs) {
            if (!(in instanceof RF2Input)) continue;
            this.inputs.add((RF2Input)in);
        }
    }

    @Override
    public Iterator<Ontology> getOntologyVersions(IProgressMonitor monitor) throws ImportException {
        return new OntologyInterator(monitor);
    }

    @Override
    public List<String> getProblems() {
        return this.problems;
    }

    protected IModuleDependencyRefset loadModuleDependencies(RF2Input input) throws ImportException {
        HashSet<InputStream> iss = new HashSet<InputStream>();
        Input.InputType inputType = input.getInputType();
        for (String md : input.getModuleDependenciesRefsetFiles()) {
            String message = "Unable to load module dependencias. Please check your input configuration file. (input type = " + inputType + ", file=" + md + ")";
            try {
                iss.add(input.getInputStream(md));
            }
            catch (NullPointerException e) {
                log.error(message, (Throwable)e);
                throw new ImportException(message, e);
            }
            catch (IOException e) {
                log.error(message, (Throwable)e);
                throw new ImportException(message, e);
            }
        }
        IModuleDependencyRefset res = RefsetImporter.importModuleDependencyRefset(iss);
        return res;
    }

    protected Map<String, Set<Version>> getModuleVersionsToLoad(RF2Input in) {
        HashMap<String, Set<Version>> res = new HashMap<String, Set<Version>>();
        for (ModuleInfo mi : in.getModules()) {
            String moduleId = mi.getId();
            HashSet<Version> versionsToLoad = (HashSet<Version>)res.get(moduleId);
            if (versionsToLoad == null) {
                versionsToLoad = new HashSet<Version>();
                res.put(moduleId, versionsToLoad);
            }
            for (Version v : mi.getVersions()) {
                versionsToLoad.add(v);
            }
        }
        return res;
    }

    protected void populateCDs(Map<String, List<String[]>> cdMap, String referencedComponentId, String featureId, String operator, String value, String unit) {
        List<Object> list;
        if (!cdMap.containsKey(referencedComponentId)) {
            list = new ArrayList();
            cdMap.put(referencedComponentId, list);
        } else {
            list = cdMap.get(referencedComponentId);
        }
        list.add(new String[]{featureId, operator, value, unit});
    }

    protected <R extends RefsetRow> void loadReferenceSet(RF2Input input, String refsetFile, Map<String, String> modMap, Map<String, R> refsetMap, IRefsetFactory<R> factory) throws ImportException {
        HashSet<String> unknownModules = new HashSet<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(input.getInputStream(refsetFile), Charset.forName("UTF8")));
            Object line = br.readLine();
            while (null != (line = br.readLine())) {
                RefsetRow currRow;
                if (((String)line).trim().length() < 1) continue;
                String[] fields = ((String)line).split("\t");
                if (fields.length < 6) {
                    throw new RuntimeException("Refset: Mis-formatted line, expected >= 6 tab-separated fields, got: " + (String)line);
                }
                String id = fields[0];
                String effectiveTime = fields[1];
                String active = fields[2];
                String moduleId = fields[3];
                String refsetId = fields[4];
                String referencedComponentId = fields[5];
                String tgtVer = modMap.get(moduleId);
                if (null == tgtVer) {
                    unknownModules.add(moduleId);
                    continue;
                }
                int rel = effectiveTime.compareTo(tgtVer);
                if (rel > 0 || (currRow = (RefsetRow)refsetMap.get(id)) != null && effectiveTime.compareTo(currRow.getEffectiveTime()) <= 0) continue;
                String[] extras = new String[fields.length - 6];
                System.arraycopy(fields, 6, extras, 0, extras.length);
                R rr = factory.create(id, effectiveTime, active, moduleId, refsetId, referencedComponentId, extras);
                refsetMap.put(id, rr);
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new ImportException("Unable to load reference set file. Please check your input configuration file (input type = " + input.getInputType() + ", file=" + refsetFile + ")", t);
        }
        finally {
            for (String moduleId : unknownModules) {
                log.info("Refset: Ignored data from module '" + moduleId + "' found in " + refsetFile);
            }
        }
    }

    protected VersionRows getBundle(BaseImporter.ImportEntry entry) throws ImportException {
        HashMap<String, String> modMap = new HashMap<String, String>();
        for (BaseImporter.Module module : entry.getModules()) {
            String modId = module.getModuleId();
            String modVer = module.getModuleVersion();
            modMap.put(modId, modVer);
        }
        for (Map.Entry entry2 : modMap.entrySet()) {
            log.info("Modules: '" + (String)entry2.getKey() + "'\t'" + (String)entry2.getValue() + "'");
        }
        HashMap<String, ConceptRow> conceptMap = new HashMap<String, ConceptRow>();
        HashMap<String, RelationshipRow> hashMap = new HashMap<String, RelationshipRow>();
        HashMap cdMap = new HashMap();
        HashMap adMap = new HashMap();
        HashMap owlMap = new HashMap();
        RF2Input input = (RF2Input)entry.getInput();
        Input.InputType inputType = input.getInputType();
        Set conceptsFiles = input.getConceptsFiles();
        log.info("Reading concepts info: " + conceptsFiles.size());
        for (Object conceptsFile : conceptsFiles) {
            String message = "Unable to load concepts file. Please check your input configuration file. (input type = " + inputType + ", file=" + (String)conceptsFile + ")";
            try {
                this.loadConceptRows(modMap, conceptMap, input.getInputStream((String)conceptsFile));
            }
            catch (NullPointerException e) {
                log.error(message, (Throwable)e);
                throw new ImportException(message, e);
            }
            catch (IOException e) {
                log.error(message, (Throwable)e);
                throw new ImportException(message, e);
            }
        }
        Set relationshipsFiles = input.getStatedRelationshipsFiles();
        if (relationshipsFiles == null || relationshipsFiles.isEmpty()) {
            relationshipsFiles = input.getRelationshipsFiles();
            log.info("Reading inferred relationships info: " + relationshipsFiles.size());
        } else {
            log.info("Reading stated relationships info: " + relationshipsFiles.size());
        }
        if (relationshipsFiles == null || relationshipsFiles.isEmpty()) {
            throw new ImportException("No relationships files was specified.");
        }
        for (Object relationshipsFile : relationshipsFiles) {
            String message = "Unable to load relationships file. Please check your input configuration file. (input type = " + inputType + ", file=" + (String)relationshipsFile + ")";
            try {
                this.loadRelationshipRows(modMap, hashMap, input.getInputStream((String)relationshipsFile));
            }
            catch (NullPointerException e) {
                log.error(message, (Throwable)e);
                throw new ImportException(message, e);
            }
            catch (IOException e) {
                log.error(message, (Throwable)e);
                throw new ImportException(message, e);
            }
        }
        Set concreteDomainRefsetFiles = input.getConcreteDomainRefsetFiles();
        log.info("Reading concrete domains reference set info: " + concreteDomainRefsetFiles.size());
        for (Object filename : concreteDomainRefsetFiles) {
            try {
                this.loadReferenceSet(input, (String)filename, modMap, cdMap, IRefsetFactory.CD);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String msg = "Error loading concrete domains reference set: " + (String)filename + ". Possibly has wrong number of columns.";
                log.error(msg, (Throwable)e);
                throw new ImportException(msg, e);
            }
        }
        Set attributeDomainRefsetFiles = input.getAttributeDomainRefsetFiles();
        log.info("Reading attribute domains reference set info: " + attributeDomainRefsetFiles.size());
        for (Object filename : attributeDomainRefsetFiles) {
            try {
                this.loadReferenceSet(input, (String)filename, modMap, adMap, IRefsetFactory.AD);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String msg = "Error loading attribute domains reference set: " + (String)filename + ". Possibly has wrong number of columns.";
                log.error(msg, (Throwable)e);
                throw new ImportException(msg, e);
            }
        }
        Set owlOntologyRefsetFiles = input.getOwlOntologyRefsetFiles();
        log.info("Reading OWL Ontology reference set info: " + owlOntologyRefsetFiles.size());
        for (Object filename : owlOntologyRefsetFiles) {
            try {
                this.loadReferenceSet(input, (String)filename, modMap, owlMap, IRefsetFactory.OWL);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String msg = "Error loading OWL Ontology reference set: " + (String)filename + ". Possibly has wrong number of columns.";
                log.error(msg, (Throwable)e);
                throw new ImportException(msg, e);
            }
        }
        Set owlAxiomRefsetFiles = input.getOwlAxiomRefsetFiles();
        log.info("Reading OWL Axiom reference set info: " + owlAxiomRefsetFiles.size());
        for (String filename : owlAxiomRefsetFiles) {
            try {
                this.loadReferenceSet(input, filename, modMap, owlMap, IRefsetFactory.OWL);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String msg = "Error loading OWL Axiom reference set: " + filename + ". Possibly has wrong number of columns.";
                log.error(msg, (Throwable)e);
                throw new ImportException(msg, e);
            }
        }
        VersionRows vr = new VersionRows(conceptMap.values(), hashMap.values(), cdMap.values(), adMap.values(), owlMap.values());
        conceptMap = null;
        Object var4_8 = null;
        cdMap = null;
        adMap = null;
        owlMap = null;
        return vr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRelationshipRows(Map<String, String> modMap, Map<String, RelationshipRow> relationshipMap, InputStream inputStream) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inputStream));
            String line = br.readLine();
            while (null != (line = br.readLine())) {
                RelationshipRow currRelationshipRow;
                int rel;
                if (line.trim().length() < 1) continue;
                int idx1 = line.indexOf(9);
                int idx2 = line.indexOf(9, idx1 + 1);
                int idx3 = line.indexOf(9, idx2 + 1);
                int idx4 = line.indexOf(9, idx3 + 1);
                int idx5 = line.indexOf(9, idx4 + 1);
                int idx6 = line.indexOf(9, idx5 + 1);
                int idx7 = line.indexOf(9, idx6 + 1);
                int idx8 = line.indexOf(9, idx7 + 1);
                int idx9 = line.indexOf(9, idx8 + 1);
                if (idx1 < 0 || idx2 < 0 || idx3 < 0 || idx4 < 0 || idx5 < 0 || idx6 < 0 || idx7 < 0 || idx8 < 0 || idx9 < 0) {
                    br.close();
                    throw new RuntimeException("Relationships: Mis-formatted line, expected 10 tab-separated fields, got: " + line);
                }
                String id = line.substring(0, idx1);
                String effectiveTime = line.substring(idx1 + 1, idx2);
                String active = line.substring(idx2 + 1, idx3);
                String moduleId = line.substring(idx3 + 1, idx4);
                String sourceId = line.substring(idx4 + 1, idx5);
                String destinationId = line.substring(idx5 + 1, idx6);
                String relationshipGroup = line.substring(idx6 + 1, idx7);
                String typeId = line.substring(idx7 + 1, idx8);
                String characteristicTypeId = line.substring(idx8 + 1, idx9);
                String modifierId = line.substring(idx9 + 1);
                String tgtVer = modMap.get(moduleId);
                if (tgtVer == null || (rel = effectiveTime.compareTo(tgtVer)) > 0 || (currRelationshipRow = relationshipMap.get(id)) != null && effectiveTime.compareTo(currRelationshipRow.getEffectiveTime()) <= 0) continue;
                RelationshipRow rr = new RelationshipRow(id, effectiveTime, active, moduleId, sourceId, destinationId, relationshipGroup, typeId, characteristicTypeId, modifierId);
                relationshipMap.put(id, rr);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConceptRows(Map<String, String> modMap, Map<String, ConceptRow> conceptMap, InputStream inputStream) throws IOException, UnsupportedEncodingException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inputStream));
            String line = br.readLine();
            while (null != (line = br.readLine())) {
                ConceptRow currConceptRow;
                int rel;
                if ((line = new String(line.getBytes(), "UTF8")).trim().length() < 1) continue;
                int idx1 = line.indexOf(9);
                int idx2 = line.indexOf(9, idx1 + 1);
                int idx3 = line.indexOf(9, idx2 + 1);
                int idx4 = line.indexOf(9, idx3 + 1);
                if (idx1 < 0 || idx2 < 0 || idx3 < 0 || idx4 < 0) {
                    br.close();
                    throw new RuntimeException("Concepts: Mis-formatted line, expected at least 5 tab-separated fields, got: " + line);
                }
                String id = line.substring(0, idx1);
                String effectiveTime = line.substring(idx1 + 1, idx2);
                String active = line.substring(idx2 + 1, idx3);
                String moduleId = line.substring(idx3 + 1, idx4);
                String definitionStatusId = line.substring(idx4 + 1);
                String tgtVer = modMap.get(moduleId);
                if (tgtVer == null || (rel = effectiveTime.compareTo(tgtVer)) > 0 || (currConceptRow = conceptMap.get(id)) != null && effectiveTime.compareTo(currConceptRow.getEffectiveTime()) <= 0) continue;
                ConceptRow cr = new ConceptRow(id, effectiveTime, active, moduleId, definitionStatusId);
                conceptMap.put(id, cr);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Concept getConcept(String id, Map<String, Concept> ci) {
        Concept c = ci.get(id);
        if (c == null) {
            c = new NamedConcept(id);
            ci.put(id, c);
        }
        return c;
    }

    protected NamedRole getRole(String id, Map<String, NamedRole> ri) {
        NamedRole r = ri.get(id);
        if (r == null) {
            r = new NamedRole(id);
            ri.put(id, r);
        }
        return r;
    }

    protected NamedFeature getFeature(String id, Map<String, NamedFeature> fi) {
        NamedFeature f = fi.get(id);
        if (f == null) {
            f = new NamedFeature(id);
            fi.put(id, f);
        }
        return f;
    }

    protected void populateParent(String src, String tgt, Map<String, Set<String>> parents) {
        Set<String> prs = parents.get(src);
        if (prs == null) {
            prs = new TreeSet<String>();
            parents.put(src, prs);
        }
        prs.add(tgt);
    }

    protected void populateChildren(String src, String tgt, Map<String, Set<String>> children) {
        Set<String> prs = children.get(src);
        if (prs == null) {
            prs = new TreeSet<String>();
            children.put(src, prs);
        }
        prs.add(tgt);
    }

    protected void populateRels(String comp, String src, String role, String tgt, String group, Map<String, List<String[]>> rels) {
        List<String[]> val = rels.get(src);
        if (val == null) {
            val = new ArrayList<String[]>();
            rels.put(src, val);
        }
        val.add(new String[]{comp, role, tgt, group});
    }

    protected void populateRoles(Set<String> roles, String parentSCTID, String rightIdentityIds, Map<String, Set<String>> children, Map<String, Map<String, String>> rolesMap) {
        if (roles == null) {
            return;
        }
        for (String role : roles) {
            String ri;
            Set<String> cs = children.get(role);
            if (cs != null) {
                this.populateRoles(cs, role, rightIdentityIds, children, rolesMap);
            }
            if (null == rightIdentityIds) continue;
            String[] ris = rightIdentityIds.split("[,]");
            String string = ri = ris[0].equals(role) ? ris[1] : null;
            if (ri != null) {
                this.populateRoleDef(role, ri, parentSCTID, rolesMap);
                continue;
            }
            this.populateRoleDef(role, "", parentSCTID, rolesMap);
        }
    }

    protected void populateRoleDef(String code, String rightId, String parentRole, Map<String, Map<String, String>> roles) {
        Map<String, String> vals = roles.get(code);
        if (vals == null) {
            vals = new HashMap<String, String>();
            roles.put(code, vals);
        }
        vals.put("rightID", rightId);
        vals.put("parentrole", parentRole);
    }

    protected Set<Set<RoleValuePair>> groupRoles(List<String[]> groups) {
        HashMap<String, HashSet<RoleValuePair>> roleGroups = new HashMap<String, HashSet<RoleValuePair>>();
        for (String[] group : groups) {
            String comp = group[0];
            String attr = group[1];
            String val = group[2];
            String roleGroup = group[3];
            HashSet<RoleValuePair> lrvp = (HashSet<RoleValuePair>)roleGroups.get(roleGroup);
            if (lrvp == null) {
                lrvp = new HashSet<RoleValuePair>();
                roleGroups.put(roleGroup, lrvp);
            }
            lrvp.add(new RoleValuePair(attr, val, comp));
        }
        HashSet<Set<RoleValuePair>> res = new HashSet<Set<RoleValuePair>>();
        for (String roleGroup : roleGroups.keySet()) {
            Set val = (Set)roleGroups.get(roleGroup);
            if ("0".equals(roleGroup)) {
                for (RoleValuePair rvp : val) {
                    HashSet<RoleValuePair> sin = new HashSet<RoleValuePair>();
                    sin.add(rvp);
                    res.add(sin);
                }
                continue;
            }
            HashSet<RoleValuePair> item = new HashSet<RoleValuePair>();
            for (RoleValuePair trvp : val) {
                item.add(trvp);
            }
            res.add(item);
        }
        return res;
    }

    protected OntologyBuilder getOntologyBuilder(VersionRows vr, String rootModuleId, String rootModuleVersion, Map<String, String> metadata) {
        return new OntologyBuilder(vr, rootModuleId, rootModuleVersion, metadata);
    }

    protected class OntologyBuilder {
        protected final VersionRows vr;
        protected final String rootModuleId;
        protected final String rootModuleVersion;
        protected final Map<String, String> primitive = new HashMap<String, String>();
        protected final Map<String, Set<String>> parents = new HashMap<String, Set<String>>();
        protected final Map<String, Set<String>> children = new HashMap<String, Set<String>>();
        protected final Map<String, List<String[]>> rels = new HashMap<String, List<String[]>>();
        protected final Map<String, Map<String, String>> roles = new HashMap<String, Map<String, String>>();
        protected final List<String> lateralizableConcepts = new LinkedList<String>();
        protected final String conceptDefinedId;
        protected final String someId;
        protected final String isAId;
        protected String lateralityId;
        protected final String conceptModelAttId;
        protected final String neverGroupedIdsString;
        protected final String fsnId;
        protected final String synonymId;
        protected final String definitionId;
        protected final String rightIdentityIds;
        protected final String roleGroupId;
        protected final String measurementTypeInt;
        protected final String measurementTypeFloat;
        protected final String equalsOperatorId;
        protected final String unitRoleId;
        protected final Set<String> neverGroupedIds = new HashSet<String>();
        protected final Map<String, Concept> ci = new HashMap<String, Concept>();
        protected final Map<String, NamedRole> ri = new HashMap<String, NamedRole>();
        protected final Map<String, NamedFeature> fi = new HashMap<String, NamedFeature>();
        protected final Collection<Axiom> statedAxioms = new ArrayList<Axiom>();
        protected final Map<String, String> featureType = new HashMap<String, String>();
        protected final Map<String, List<String[]>> cdsMap = new HashMap<String, List<String[]>>();

        public OntologyBuilder(VersionRows vr, String rootModuleId, String rootModuleVersion, Map<String, String> metadata) {
            this.vr = vr;
            this.rootModuleId = rootModuleId;
            this.rootModuleVersion = rootModuleVersion;
            this.conceptDefinedId = metadata.get("conceptDefinedId");
            this.someId = metadata.get("someId");
            this.isAId = metadata.get("isAId");
            this.lateralityId = metadata.get("lateralityId");
            this.conceptModelAttId = metadata.get("conceptModelAttId");
            this.neverGroupedIdsString = metadata.get("neverGroupedIds");
            this.fsnId = metadata.get("fsnId");
            this.synonymId = metadata.get("synonymId");
            this.definitionId = metadata.get("definitionId");
            this.rightIdentityIds = metadata.get("rightIdentityIds");
            this.roleGroupId = metadata.get("roleGroupId");
            this.measurementTypeInt = metadata.get("intTypeId");
            this.measurementTypeFloat = metadata.get("floatTypeId");
            this.equalsOperatorId = metadata.get("equalsOperatorId");
            this.unitRoleId = metadata.get("unitRoleId");
            if (this.conceptDefinedId == null) {
                log.warn("Metadata value for conceptDefinedId was not found. Import process might produce unexpected results.");
            }
            if (this.someId == null) {
                log.warn("Metadata value for someId was not found. Import process might produce unexpected results.");
            }
            if (this.isAId == null) {
                log.warn("Metadata value for isAId was not found. Import process might produce unexpected results.");
            }
            if (this.lateralityId == null) {
                this.lateralityId = "";
                log.warn("Metadata value for lateralityId was not found. Import process might produce unexpected results.");
            }
            if (this.conceptModelAttId == null) {
                log.warn("Metadata value for conceptModelAttId was not found. Import process might produce unexpected results.");
            }
            if (this.neverGroupedIdsString == null && vr.getAttributeDomainRows().isEmpty()) {
                log.warn("Metadata value for neverGroupedIds was not found. Import process might produce unexpected results.");
            }
            this.initDefaultNeverGroupedIds();
            for (RefsetRow row : vr.getAttributeDomainRows()) {
                if (!this.isActive(row.getActive()) || !"0".equals(row.getExtras()[1])) continue;
                this.neverGroupedIds.add(row.getReferencedComponentId());
            }
            if (log.isInfoEnabled()) {
                log.info("Never-grouped attributes: " + this.neverGroupedIds);
            }
            if (this.fsnId == null) {
                log.warn("Metadata value for fsnId was not found. Import process might produce unexpected results.");
            }
            if (this.synonymId == null) {
                log.warn("Metadata value for synonymId was not found. Import process might produce unexpected results.");
            }
            if (this.definitionId == null) {
                log.warn("Metadata value for definitionId was not found. Import process might produce unexpected results.");
            }
            if (this.rightIdentityIds == null) {
                log.warn("Metadata value for rightIdentityIds was not found. Import process might produce unexpected results.");
            }
            if (this.roleGroupId == null) {
                log.warn("Metadata value for roleGroupId was not found. Import process might produce unexpected results.");
            }
            if (this.measurementTypeFloat == null) {
                log.warn("Metadata value for floatTypeId was not found. Import process might produce unexpected results.");
            }
            if (this.measurementTypeInt == null) {
                log.warn("Metadata value for intTypeId was not found. Import process might produce unexpected results.");
            }
            if (this.equalsOperatorId == null) {
                log.warn("Metadata value for equalsOperatorId was not found. Import process might produce unexpected results.");
            }
            if (this.unitRoleId == null) {
                log.warn("Metadata value for unitRoleId was not found. Import process might produce unexpected results.");
            }
        }

        protected void initDefaultNeverGroupedIds() {
            this.neverGroupedIds.clear();
            if (null != this.neverGroupedIdsString) {
                String[] parts;
                for (String part : parts = this.neverGroupedIdsString.split("[,]")) {
                    if (part.isEmpty()) continue;
                    this.neverGroupedIds.add(part);
                }
            }
        }

        protected Ontology build(IProgressMonitor monitor) throws URISyntaxException {
            log.info("Processing " + this.vr.getConceptRows().size() + " concept rows");
            for (ConceptRow cr : this.vr.getConceptRows()) {
                String id = cr.getId();
                if (!this.isActive(cr.getActive())) continue;
                if (!this.conceptDefinedId.equals(cr.getDefinitionStatusId())) {
                    this.primitive.put(id, "1");
                    continue;
                }
                this.primitive.put(id, "0");
            }
            log.info("Processing " + this.vr.getRelationshipRows().size() + " relationship rows");
            for (RelationshipRow rr : this.vr.getRelationshipRows()) {
                if (!this.someId.equals(rr.getModifierId())) {
                    throw new RuntimeException("Only existentials are supported.");
                }
                if (!this.isActive(rr.getActive())) continue;
                String type = rr.getTypeId();
                String src = rr.getSourceId();
                String dest = rr.getDestinationId();
                if (this.isAId.equals(type)) {
                    RF2Importer.this.populateParent(src, dest, this.parents);
                    RF2Importer.this.populateChildren(dest, src, this.children);
                    continue;
                }
                if (this.lateralityId.equals(type)) {
                    this.lateralizableConcepts.add(src);
                }
                RF2Importer.this.populateRels(rr.getId(), src, type, dest, rr.getRelationshipGroup(), this.rels);
            }
            log.info("Processing " + this.vr.getConcreteDomainRows().size() + " concrete domain rows");
            HashSet<String> untypedFeatures = new HashSet<String>();
            for (RefsetRow rr : this.vr.getConcreteDomainRows()) {
                if (!this.isActive(rr.getActive())) continue;
                String[] extras = rr.getExtras();
                RF2Importer.this.populateCDs(this.cdsMap, rr.getReferencedComponentId(), rr.getRefsetId(), extras[1], extras[2], extras[0]);
                Set<String> allParents = this.parents.get(rr.getRefsetId());
                if (allParents == null) {
                    log.error("Could not find refset id " + rr.getRefsetId() + " in meta-data hierarchy. There might be a problem with the concrete domains definitions.");
                    continue;
                }
                if (allParents.contains(this.measurementTypeFloat)) {
                    this.featureType.put(rr.getRefsetId(), "float");
                    continue;
                }
                if (allParents.contains(this.measurementTypeInt)) {
                    this.featureType.put(rr.getRefsetId(), "int");
                    continue;
                }
                untypedFeatures.add(rr.getRefsetId());
            }
            for (String refsetId : untypedFeatures) {
                log.error("ERROR: Could not determine the type (int/float) of " + refsetId);
            }
            log.info("Creating role axioms");
            RF2Importer.this.populateRoles(this.children.get(this.conceptModelAttId), "", this.rightIdentityIds, this.children, this.roles);
            for (String r1 : this.roles.keySet()) {
                String rightId;
                String parentRole = this.roles.get(r1).get("parentrole");
                if (!"".equals(parentRole)) {
                    NamedRole lhs = RF2Importer.this.getRole(r1, this.ri);
                    NamedRole rhs = RF2Importer.this.getRole(parentRole, this.ri);
                    this.statedAxioms.add((Axiom)new RoleInclusion(new Role[]{lhs}, (Role)rhs));
                }
                if ("".equals(rightId = this.roles.get(r1).get("rightID"))) continue;
                NamedRole lhs1 = RF2Importer.this.getRole(r1, this.ri);
                NamedRole lhs2 = RF2Importer.this.getRole(rightId, this.ri);
                this.statedAxioms.add((Axiom)new RoleInclusion(new Role[]{lhs1, lhs2}, (Role)lhs1));
            }
            log.info("Creating axioms for " + this.primitive.size() + " active concepts");
            for (String c1 : this.primitive.keySet()) {
                Set<String> prs = this.parents.get(c1);
                int numParents = prs != null ? prs.size() : 0;
                List<String[]> relsVal = this.rels.get(c1);
                int numRels = relsVal != null ? 1 : 0;
                List<String[]> cdsVal = this.cdsMap.get(c1);
                int numCds = cdsVal != null ? 1 : 0;
                int numElems = numParents + numRels + numCds;
                if (numParents == 0 && numElems > 0) {
                    log.warn("Root concept " + c1 + " has non-ISA relationships but no ISA relationships.");
                }
                if (numElems == 0) continue;
                if (numElems == 1 && numParents == 1) {
                    Concept lhs = RF2Importer.this.getConcept(c1, this.ci);
                    Iterator<Object> rhs = RF2Importer.this.getConcept(prs.iterator().next(), this.ci);
                    this.statedAxioms.add((Axiom)new ConceptInclusion(lhs, rhs));
                    continue;
                }
                ArrayList<Concept> conjs = new ArrayList<Concept>();
                if (prs != null) {
                    for (String string : prs) {
                        conjs.add(RF2Importer.this.getConcept(string, this.ci));
                    }
                }
                if (cdsVal != null) {
                    for (String[] stringArray : cdsVal) {
                        this.mapDatatype(conjs, stringArray);
                    }
                }
                if (relsVal != null) {
                    for (Set set : RF2Importer.this.groupRoles(relsVal)) {
                        this.mapRoles(conjs, set);
                    }
                }
                ConceptInclusion axiom = new ConceptInclusion(RF2Importer.this.getConcept(c1, this.ci), (Concept)new Conjunction(conjs));
                this.statedAxioms.add((Axiom)axiom);
                if (!this.primitive.get(c1).equals("0")) continue;
                ConceptInclusion conceptInclusion = new ConceptInclusion((Concept)new Conjunction(conjs), RF2Importer.this.getConcept(c1, this.ci));
                this.statedAxioms.add((Axiom)conceptInclusion);
            }
            log.info("Add functional feature axioms");
            for (NamedFeature feature : this.fi.values()) {
                this.statedAxioms.add((Axiom)new FunctionalFeature((Feature)feature));
            }
            this.processAxiomRows(monitor);
            log.info("Finished building ontology");
            return new Ontology(this.rootModuleId, this.rootModuleVersion, this.statedAxioms, null);
        }

        protected void processAxiomRows(IProgressMonitor monitor) {
            ArrayList<String> namespace = new ArrayList<String>();
            ArrayList<String> axiomList = new ArrayList<String>();
            log.info("Processing " + this.vr.getOwlRows().size() + " OWL rows");
            for (RefsetRow row : this.vr.getOwlRows()) {
                if (!this.isActive(row.getActive())) continue;
                String owlFragment = row.getExtras()[0];
                if ("733073007".equals(row.getRefsetId())) {
                    axiomList.add(owlFragment);
                    continue;
                }
                if ("762103008".equals(row.getRefsetId())) {
                    if ("734146004".equals(row.getReferencedComponentId())) {
                        if (!owlFragment.startsWith("Prefix(:=")) {
                            namespace.add(owlFragment);
                            continue;
                        }
                        namespace.add("Prefix(:=<>)");
                        continue;
                    }
                    if ("734147008".equals(row.getReferencedComponentId())) continue;
                    log.warn("Unexpected referencedComponentId in: " + row);
                    continue;
                }
                log.warn("Unexpected refsetId in: " + row);
            }
            String namespaceStr = namespace.stream().collect(Collectors.joining("\n"));
            String axiomStr = axiomList.stream().collect(Collectors.joining("\n  "));
            String input = namespaceStr + "\nOntology(\n  " + axiomStr + "\n)";
            System.err.println(input);
            System.err.flush();
            ReaderDocumentSource source = new ReaderDocumentSource((Reader)new StringReader(input), IRI.generateDocumentIRI(), FUNCTIONAL_SYNTAX_DOCUMENT_FORMAT, null);
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            try {
                OWLOntology owlOntology = manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)source);
                Iterator<Ontology> itr = new OWLImporter(owlOntology).getOntologyVersions(monitor);
                while (itr.hasNext()) {
                    Collection importedStatedAxioms = itr.next().getStatedAxioms();
                    this.statedAxioms.addAll(importedStatedAxioms);
                }
            }
            catch (OWLOntologyCreationException e) {
                throw new RuntimeException("Failed to process OWL axioms", e);
            }
        }

        protected boolean isActive(String active) {
            return "1".equals(active);
        }

        protected void mapRoles(List<Concept> conjs, Set<RoleValuePair> rvs) {
            if (rvs.size() > 1) {
                Concept[] innerConjs = new Concept[rvs.size()];
                int j = 0;
                for (RoleValuePair rv : rvs) {
                    NamedRole role = RF2Importer.this.getRole(rv.role, this.ri);
                    Concept filler = this.resolveFiller(RF2Importer.this.getConcept(rv.value, this.ci), rv.id);
                    Existential exis = new Existential((Role)role, filler);
                    innerConjs[j++] = exis;
                }
                conjs.add((Concept)new Existential((Role)RF2Importer.this.getRole(this.roleGroupId, this.ri), (Concept)new Conjunction(innerConjs)));
            } else {
                RoleValuePair first = rvs.iterator().next();
                NamedRole role = RF2Importer.this.getRole(first.role, this.ri);
                Concept filler = this.resolveFiller(RF2Importer.this.getConcept(first.value, this.ci), first.id);
                Existential exis = new Existential((Role)role, filler);
                if (this.neverGroupedIds.contains(first.role)) {
                    conjs.add((Concept)exis);
                } else {
                    conjs.add((Concept)new Existential((Role)RF2Importer.this.getRole(this.roleGroupId, this.ri), (Concept)exis));
                }
            }
        }

        protected Concept resolveFiller(Concept value, String compId) {
            if (this.cdsMap.containsKey(compId)) {
                ArrayList<Concept> concepts = new ArrayList<Concept>();
                concepts.add(value);
                for (String[] datatype : this.cdsMap.get(compId)) {
                    this.mapDatatype(concepts, datatype);
                }
                Conjunction result = new Conjunction(concepts);
                if (log.isTraceEnabled()) {
                    log.trace("Mapping CD info: " + result.toString());
                }
                return result;
            }
            return value;
        }

        protected void mapDatatype(List<Concept> conjs, String[] datatype) {
            IntegerLiteral value;
            NamedFeature feature = RF2Importer.this.getFeature(datatype[0], this.fi);
            String type = this.featureType.get(datatype[0]);
            if (type == null) {
                log.error("Ignoring feature " + datatype[0] + " (it has no type). There might be a problem with the concrete domains definitions.");
                return;
            }
            String operatorId = datatype[1];
            String unitId = datatype[3];
            if (type.equals("int")) {
                value = new IntegerLiteral(Integer.parseInt(datatype[2]));
            } else if (type.equals("float")) {
                value = new DecimalLiteral(new BigDecimal(datatype[2]));
            } else {
                log.error("Unknown type: " + type);
                return;
            }
            if (this.equalsOperatorId.equals(operatorId)) {
                Concept[] concepts = new Concept[]{new Existential((Role)RF2Importer.this.getRole(this.unitRoleId, this.ri), RF2Importer.this.getConcept(unitId, this.ci)), new Datatype((Feature)feature, Operator.EQUALS, (Literal)value)};
                conjs.add((Concept)new Existential((Role)RF2Importer.this.getRole(this.roleGroupId, this.ri), (Concept)new Conjunction(concepts)));
            } else {
                log.error("Unknown operator: " + operatorId);
            }
        }

        protected void populateInactiveRels(String comp, String src, String role, String tgt, String group, Map<String, List<String[]>> inactiveRels) {
            List<String[]> val = inactiveRels.get(src);
            if (val == null) {
                val = new ArrayList<String[]>();
                inactiveRels.put(src, val);
            }
            val.add(new String[]{comp, role, tgt, group});
        }

        protected void populateInactiveParent(String src, String tgt, Map<String, Set<String>> inactiveParents) {
            Set<String> prs = inactiveParents.get(src);
            if (prs == null) {
                prs = new TreeSet<String>();
                inactiveParents.put(src, prs);
            }
            prs.add(tgt);
        }

        protected void populateInactiveChildren(String src, String tgt, Map<String, Set<String>> inactiveChildren) {
            Set<String> prs = inactiveChildren.get(src);
            if (prs == null) {
                prs = new TreeSet<String>();
                inactiveChildren.put(src, prs);
            }
            prs.add(tgt);
        }

        protected void populateInactiveRoles(Set<String> roles, String parentSCTID, String version, String rightIdentityIds, Map<String, Set<String>> inactiveChildren, Map<String, Map<String, String>> inactiveRoles) {
            if (roles == null) {
                return;
            }
            for (String role : roles) {
                String[] ris;
                String ri;
                Set<String> cs = inactiveChildren.get(role);
                if (cs != null) {
                    this.populateInactiveRoles(cs, role, version, rightIdentityIds, inactiveChildren, inactiveRoles);
                }
                String string = ri = (ris = rightIdentityIds.split("[,]"))[0].equals(role) ? ris[1] : null;
                if (ri != null) {
                    this.populateInactiveRoleDef(role, ri, parentSCTID, inactiveRoles);
                    continue;
                }
                this.populateInactiveRoleDef(role, "", parentSCTID, inactiveRoles);
            }
        }

        protected void populateInactiveRoleDef(String code, String rightId, String parentRole, Map<String, Map<String, String>> inactiveRoles) {
            Map<String, String> vals = inactiveRoles.get(code);
            if (vals == null) {
                vals = new HashMap<String, String>();
                inactiveRoles.put(code, vals);
            }
            vals.put("rightID", rightId);
            vals.put("parentrole", parentRole);
        }
    }

    class OntologyInterator
    implements Iterator<Ontology> {
        private final Queue<BaseImporter.ImportEntry> entries = new LinkedList<BaseImporter.ImportEntry>();
        private final IProgressMonitor monitor;

        private void processNext() throws ImportException {
            RF2Input in = RF2Importer.this.inputs.remove();
            log.info("Loading module dependencies");
            IModuleDependencyRefset mdr = RF2Importer.this.loadModuleDependencies(in);
            if (mdr == null) {
                throw new ImportException("Couldn't load module dependency reference set for RF2 input files.");
            }
            Map deps = mdr.getModuleDependencies();
            log.info("Determining which root modules and versions to load");
            Map<String, Set<Version>> toLoad = RF2Importer.this.getModuleVersionsToLoad(in);
            log.info("Creating import entries");
            for (String rootModuleId : toLoad.keySet()) {
                Set<Version> versions = toLoad.get(rootModuleId);
                for (Version version : versions) {
                    String ver = version.getId();
                    Map metadata = version.getMetadata();
                    Map versionMap = (Map)deps.get(rootModuleId);
                    if (null == versionMap) {
                        throw new ImportException("Root module not found in MDRS: " + rootModuleId);
                    }
                    ModuleDependency md = (ModuleDependency)versionMap.get(ver);
                    if (md == null) {
                        throw new ImportException("Version " + ver + " of module " + rootModuleId + " was not found in MDRS.");
                    }
                    HashSet<BaseImporter.Module> modules = new HashSet<BaseImporter.Module>();
                    LinkedList<ModuleDependency> depends = new LinkedList<ModuleDependency>();
                    depends.add(md);
                    while (!depends.isEmpty()) {
                        ModuleDependency d = (ModuleDependency)depends.poll();
                        modules.add(new BaseImporter.Module(d.getId(), d.getVersion()));
                        depends.addAll(d.getDependencies());
                    }
                    this.entries.add(new BaseImporter.ImportEntry(rootModuleId, ver, metadata, modules, (Input)in));
                }
            }
            log.info("Found " + this.entries.size() + " entries to import");
        }

        public OntologyInterator(IProgressMonitor monitor) throws ImportException {
            this.monitor = monitor;
            this.processNext();
        }

        @Override
        public boolean hasNext() {
            return !this.entries.isEmpty() || !RF2Importer.this.inputs.isEmpty();
        }

        @Override
        public Ontology next() throws RuntimeException {
            try {
                if (this.entries.isEmpty()) {
                    this.processNext();
                }
                BaseImporter.ImportEntry entry = this.entries.remove();
                VersionRows bundle = RF2Importer.this.getBundle(entry);
                String ontologyId = entry.getRootModuleId();
                String ontologyVersion = entry.getRootModuleVersion();
                log.info("Building ontology " + ontologyId + " (" + ontologyVersion + ")");
                OntologyBuilder builder = RF2Importer.this.getOntologyBuilder(bundle, ontologyId, ontologyVersion, entry.getMetadata());
                return builder.build(this.monitor);
            }
            catch (ImportException e) {
                log.error(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                log.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class RoleValuePair {
        final String role;
        final String value;
        final String id;

        RoleValuePair(String role, String value, String id) {
            this.role = role;
            this.value = value;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RoleValuePair other = (RoleValuePair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.role == null && other.role != null) {
                return false;
            }
            if (!this.role.equals(other.role)) {
                return false;
            }
            if (this.value == null && other.value != null) {
                return false;
            }
            return this.value.equals(other.value);
        }

        private RF2Importer getOuterType() {
            return RF2Importer.this;
        }
    }
}

