/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology;

import au.csiro.ontology.Node;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.NamedConcept;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Ontology {
    protected final String id;
    protected final String version;
    protected final Collection<Axiom> statedAxioms;
    protected final Collection<Axiom> inferredAxioms = new ArrayList<Axiom>();
    protected final Map<String, Node> nodeMap = new HashMap<String, Node>();
    protected final Set<Node> lastAffectedNodes = new HashSet<Node>();

    public Ontology(String id, String version, Collection<Axiom> statedAxioms, Map<String, Node> nodeMap, Set<Node> lastAffectedNodes) {
        this.id = id;
        this.version = version;
        this.statedAxioms = statedAxioms == null ? new ArrayList<Axiom>() : statedAxioms;
        if (nodeMap != null) {
            this.nodeMap.putAll(nodeMap);
        }
        if (lastAffectedNodes != null) {
            this.lastAffectedNodes.addAll(lastAffectedNodes);
        }
    }

    public Ontology(String id, String version, Collection<Axiom> statedAxioms, Map<String, Node> nodeMap) {
        this(id, version, statedAxioms, nodeMap, null);
    }

    public Collection<Axiom> getStatedAxioms() {
        return this.statedAxioms;
    }

    public Collection<Axiom> getInferredAxioms() {
        return this.inferredAxioms;
    }

    public Node getNode(String id) {
        return this.nodeMap.get(id);
    }

    public Iterator<Node> nodeIterator() {
        HashSet<Node> set = new HashSet<Node>(this.nodeMap.values());
        return set.iterator();
    }

    public Map<String, Node> getNodeMap() {
        return this.nodeMap;
    }

    public Node getTopNode() {
        return this.getNode(NamedConcept.TOP);
    }

    public Node getBottomNode() {
        return this.getNode(NamedConcept.BOTTOM);
    }

    public void setNodeMap(Map<String, Node> nodeMap) {
        this.nodeMap.clear();
        this.nodeMap.putAll(nodeMap);
    }

    public Set<Node> getAffectedNodes() {
        return this.lastAffectedNodes;
    }

    public void setAffectedNodes(Set<Node> nodes) {
        this.lastAffectedNodes.clear();
        this.lastAffectedNodes.addAll(nodes);
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }
}

