/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.model;

import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.Concept;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ConceptInclusion
extends Axiom {
    private Concept lhs;
    private Concept rhs;

    public ConceptInclusion() {
    }

    public ConceptInclusion(Concept lhs, Concept rhs) {
        if (null == lhs) {
            throw new IllegalArgumentException("LHS cannot be null (RHS = " + rhs + ")");
        }
        this.lhs = lhs;
        if (null == rhs) {
            throw new IllegalArgumentException("RHS cannot be null (LHS = " + lhs + ")");
        }
        this.rhs = rhs;
    }

    public String toString() {
        return this.lhs + " \u2291 " + this.rhs;
    }

    public Concept getLhs() {
        return this.lhs;
    }

    public void setLhs(Concept lhs) {
        this.lhs = lhs;
    }

    public Concept getRhs() {
        return this.rhs;
    }

    public void setRhs(Concept rhs) {
        this.rhs = rhs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
        result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptInclusion other = (ConceptInclusion)obj;
        if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
            return false;
        }
        return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
    }

    @Override
    public int compareTo(Axiom o) {
        if (!(o instanceof ConceptInclusion)) {
            return -1;
        }
        ConceptInclusion otherCi = (ConceptInclusion)o;
        int lhsRes = this.lhs.compareTo(otherCi.getLhs());
        int rhsRes = this.rhs.compareTo(otherCi.getRhs());
        if (lhsRes == 0 && rhsRes == 0) {
            return 0;
        }
        if (lhsRes != 0) {
            return lhsRes;
        }
        return rhsRes;
    }
}

