/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.protege.util;

import java.io.File;
import java.util.List;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;

public class DebugUtils {
    public static String formatAxiom(OWLAxiom a, OWLOntology ont) {
        if (a instanceof OWLSubPropertyChainOfAxiom) {
            return a.toString();
        }
        if (a instanceof OWLSubObjectPropertyOfAxiom) {
            return a.toString();
        }
        if (a instanceof OWLSubClassOfAxiom) {
            OWLSubClassOfAxiom sc = (OWLSubClassOfAxiom)a;
            return DebugUtils.formatClassExpression(sc.getSubClass(), ont) + " \u2286 " + DebugUtils.formatClassExpression(sc.getSuperClass(), ont);
        }
        if (a instanceof OWLEquivalentClassesAxiom) {
            OWLEquivalentClassesAxiom ec = (OWLEquivalentClassesAxiom)a;
            List ces = ec.getClassExpressionsAsList();
            StringBuilder sb = new StringBuilder();
            sb.append(DebugUtils.formatClassExpression((OWLClassExpression)ces.get(0), ont));
            for (int i = 1; i < ces.size(); ++i) {
                sb.append(" = ");
                sb.append(DebugUtils.formatClassExpression((OWLClassExpression)ces.get(i), ont));
            }
            return sb.toString();
        }
        if (a instanceof OWLDeclarationAxiom) {
            OWLDeclarationAxiom da = (OWLDeclarationAxiom)a;
            OWLEntity ent = da.getEntity();
            String name = ent.isOWLClass() ? DebugUtils.getLabel((OWLEntity)ent.asOWLClass(), ont) : ent.toString();
            return "init(" + name + ")";
        }
        return a.toString();
    }

    public static String formatClassExpression(OWLClassExpression ce, OWLOntology ont) {
        if (ce instanceof OWLClass) {
            return DebugUtils.getLabel((OWLEntity)ce.asOWLClass(), ont);
        }
        if (ce instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf oi = (OWLObjectIntersectionOf)ce;
            List ops = oi.getOperandsAsList();
            StringBuilder sb = new StringBuilder();
            sb.append(DebugUtils.formatClassExpression((OWLClassExpression)ops.get(0), ont));
            for (int i = 1; i < ops.size(); ++i) {
                sb.append(" \u2229 ");
                sb.append(DebugUtils.formatClassExpression((OWLClassExpression)ops.get(i), ont));
            }
            return sb.toString();
        }
        if (ce instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom osv = (OWLObjectSomeValuesFrom)ce;
            OWLObjectPropertyExpression ope = osv.getProperty();
            String role = !ope.isAnonymous() ? DebugUtils.getLabel((OWLEntity)ope.asOWLObjectProperty(), ont) : ope.toString();
            return "\u2203" + role + ".(" + DebugUtils.formatClassExpression((OWLClassExpression)osv.getFiller(), ont) + ")";
        }
        return ce.toString();
    }

    public static String getLabel(OWLEntity e, OWLOntology ont) {
        for (OWLAnnotation an : EntitySearcher.getAnnotations((OWLEntity)e, (OWLOntology)ont)) {
            if (!an.getProperty().isLabel()) continue;
            OWLAnnotationValue val = an.getValue();
            if (val instanceof IRI) {
                return ((IRI)val).toString();
            }
            if (val instanceof OWLLiteral) {
                OWLLiteral lit = (OWLLiteral)val;
                return lit.getLiteral();
            }
            if (val instanceof OWLAnonymousIndividual) {
                OWLAnonymousIndividual ind = (OWLAnonymousIndividual)val;
                return ind.toStringID();
            }
            throw new RuntimeException("Unexpected class " + val.getClass());
        }
        return e.toStringID();
    }

    public static void main(String[] args) {
        String[] vals = new String[]{"http://www.ihtsdo.org/SCT_424226004"};
        try {
            File stated = new File("src/test/resources/snomed_20110731_stated.owl");
            IRI iriStated = IRI.create((File)stated.getAbsoluteFile());
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ont = manager.loadOntology(iriStated);
            for (String val : vals) {
                OWLClass cl = manager.getOWLDataFactory().getOWLClass(IRI.create((String)val));
                System.out.println(val + " -> " + DebugUtils.getLabel((OWLEntity)cl, ont) + " -> " + ont.getReferencingAxioms((OWLPrimitive)cl).size());
                for (OWLAxiom a : ont.getReferencingAxioms((OWLPrimitive)cl)) {
                    AxiomType type = a.getAxiomType();
                    if (type != AxiomType.SUB_OBJECT_PROPERTY) continue;
                    System.out.println("  " + a);
                }
                System.out.println("--------------------------------");
                for (OWLAxiom a : ont.getReferencingAxioms((OWLPrimitive)cl)) {
                    System.out.println("  " + DebugUtils.formatAxiom(a, ont));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

