/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.HasMmsi;
import au.gov.amsa.ais.Util;

public abstract class AbstractAisBStaticDataReport
implements AisMessage,
HasMmsi {
    public static final int PART_NUMBER_A = 0;
    public static final int PART_NUMBER_B = 1;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;
    private final int repeatIndicator;
    private final int mmsi;
    private final int partNumber;

    public static int extractPartNumber(AisExtractorFactory factory, String message, int padBits) {
        AisExtractor extractor = factory.create(message, 50, padBits);
        return extractor.getValue(38, 40);
    }

    protected AbstractAisBStaticDataReport(int partNumber, AisExtractorFactory factory, String source, AisExtractor extractor) {
        this.source = source;
        this.extractor = extractor;
        this.messageId = extractor.getMessageId();
        Util.checkMessageId(this.getMessageId(), AisMessageType.STATIC_DATA_REPORT);
        this.repeatIndicator = extractor.getValue(6, 8);
        this.mmsi = extractor.getValue(8, 38);
        this.partNumber = partNumber;
    }

    protected AisExtractor getExtractor() {
        return this.extractor;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    public int getRepeatIndicator() {
        return this.repeatIndicator;
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    @Override
    public String getSource() {
        return this.source;
    }
}

