/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea;

import au.gov.amsa.ais.parse.Util;
import au.gov.amsa.util.nmea.NmeaMessageParseException;
import au.gov.amsa.util.nmea.NmeaUtil;
import au.gov.amsa.util.nmea.Talker;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NmeaMessage {
    private final LinkedHashMap<String, String> tags;
    private final List<String> items;
    private final Talker talker;
    private final SentenceInfo sentenceInfo;
    private final String checksum;
    private static final Pattern sentenceTagPattern = Pattern.compile("([1-9][0-9]*)G([1-9][0-9]*)");

    public NmeaMessage(LinkedHashMap<String, String> tags, List<String> items, String checksum) {
        this.tags = tags;
        this.items = items;
        this.talker = !items.isEmpty() && items.get(0).length() >= 3 ? NmeaUtil.getTalker(items.get(0).substring(1, 3)) : Talker.UNKNOWN;
        this.sentenceInfo = NmeaMessage.getSentenceInfo(tags, items);
        this.checksum = checksum;
    }

    public String getSource() {
        return this.tags.get("s");
    }

    public Long getUnixTimeMillis() {
        String time = this.tags.get("c");
        if (time == null) {
            return null;
        }
        try {
            return Util.parseLong(time) * 1000L;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getDestination() {
        return this.tags.get("d");
    }

    public String getSentenceGroupingFromTagBlock() {
        return this.tags.get("g");
    }

    public Integer getLineCount() {
        String count = this.tags.get("n");
        if (count == null) {
            return null;
        }
        return Util.parseInt(count);
    }

    public Long getRelativeTimeMillis() {
        String time = this.tags.get("r");
        if (time == null) {
            return null;
        }
        return Util.parseLong(time) * 1000L;
    }

    public String getText() {
        return this.tags.get("t");
    }

    public List<String> getItems() {
        return this.items;
    }

    public LinkedHashMap<String, String> getTags() {
        return this.tags;
    }

    public Talker getTalker() {
        return this.talker;
    }

    public String toLine() {
        return NmeaUtil.createNmeaLine(this.tags, this.items);
    }

    public Integer getSentenceNumber() {
        if (this.sentenceInfo != null) {
            return this.sentenceInfo.number;
        }
        return null;
    }

    public Integer getSentenceCount() {
        if (this.sentenceInfo != null) {
            return this.sentenceInfo.count;
        }
        return null;
    }

    public String getSentenceGroupId() {
        if (this.sentenceInfo != null) {
            return this.sentenceInfo.id;
        }
        return null;
    }

    public String calculateChecksum() {
        return NmeaUtil.getChecksum(NmeaUtil.createNmeaLine(this.tags, this.items));
    }

    public String getChecksum() {
        return this.checksum;
    }

    private static SentenceInfo getSentenceInfo(LinkedHashMap<String, String> tags, List<String> items) {
        try {
            String g = tags.get("g");
            if (g != null) {
                String[] parts = g.split("-");
                if (parts.length < 3) {
                    throw new NmeaMessageParseException("not enough parts available in g tag");
                }
                int number = Util.parseInt(parts[0]);
                int count = Util.parseInt(parts[1]);
                String id = parts[2];
                return new SentenceInfo(number, count, id);
            }
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                Matcher matcher = sentenceTagPattern.matcher(entry.getKey());
                if (!matcher.matches()) continue;
                int number = Util.parseInt(matcher.group(1));
                int count = Util.parseInt(matcher.group(2));
                String id = entry.getValue();
                return new SentenceInfo(number, count, id);
            }
            if (items.size() > 2 && NmeaMessage.isEncapsulationSentence(items)) {
                int number = Util.parseInt(items.get(2));
                int count = Util.parseInt(items.get(1));
                String id = items.get(3);
                return new SentenceInfo(number, count, id);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new NmeaMessageParseException(e.getMessage(), e);
        }
    }

    private static boolean isEncapsulationSentence(List<String> items) {
        return items.size() > 0 && items.get(0).startsWith("!");
    }

    public boolean isSingleSentence() {
        return this.getSentenceCount() == null || this.getSentenceCount() == 1;
    }

    public Long getArrivalTimeMillis() {
        String time = this.tags.get("a");
        if (time == null) {
            return null;
        }
        try {
            return Util.parseLong(time);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class SentenceInfo {
        int number;
        int count;
        String id;

        public SentenceInfo(int number, int count, String id) {
            this.number = number;
            this.count = count;
            this.id = id;
        }
    }
}

