/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea;

import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaMessageParser;
import au.gov.amsa.util.nmea.Talker;
import com.github.davidmoten.guavamini.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class NmeaUtil {
    private static final String[] EMPTY = new String[0];
    private static final char BACKSLASH = '\\';
    private static final Set<Integer> invalidFieldCharacters = Sets.newHashSet((Object[])new Integer[]{33, 36, 42, 44, 92, 94, 126, 127});
    private static final Set<Character> validCharacterSymbols = NmeaUtil.createValidCharacterSymbols();
    private static final String[] hexes = IntStream.range(0, 256).mapToObj(x -> {
        String s = Integer.toHexString(x).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }).collect(Collectors.toList()).toArray(EMPTY);
    private static NmeaMessageParser nmeaParser = new NmeaMessageParser();
    private static final Map<String, Talker> talkers = Arrays.asList(Talker.values()).stream().collect(Collectors.toMap(t -> t.name(), t -> t));

    private NmeaUtil() {
    }

    static void forTestCoverageOnly() {
        new NmeaUtil();
    }

    private static Set<Character> createValidCharacterSymbols() {
        String s = "AaBCcDdEFfGgHhIJKkLlMmNnPQRrSsTtUuVWxyZ";
        HashSet set = Sets.newHashSet();
        for (char ch : s.toCharArray()) {
            set.add(Character.valueOf(ch));
        }
        return set;
    }

    static boolean isValidFieldCharacter(char ch) {
        return ch <= '\u007f' && ch >= ' ' && !invalidFieldCharacters.contains(ch);
    }

    static boolean isValidCharacterSymbol(char ch) {
        return validCharacterSymbols.contains(Character.valueOf(ch));
    }

    public static boolean isValid(String sentence) {
        try {
            return sentence.substring(sentence.lastIndexOf("*") + 1).equals(NmeaUtil.getChecksum(sentence));
        }
        catch (AisParseException e) {
            return false;
        }
    }

    public static String getChecksum(String sentence) {
        return NmeaUtil.getChecksum(sentence, true);
    }

    public static String getChecksumWhenHasNoTagBlock(String sentence) {
        return NmeaUtil.getChecksumWhenHasNoTagBlock(sentence, true, 0);
    }

    public static String getChecksum(String sentence, boolean ignoreLeadingDollarOrExclamation) {
        int startIndex;
        if (sentence.startsWith("\\")) {
            startIndex = sentence.indexOf(92, 1) + 1;
            if (startIndex == 0) {
                throw new AisParseException("no closing \\ for tag block");
            }
        } else {
            startIndex = 0;
        }
        return NmeaUtil.getChecksumWhenHasNoTagBlock(sentence, ignoreLeadingDollarOrExclamation, startIndex);
    }

    private static String getChecksumWhenHasNoTagBlock(String sentenceWithoutTagBlock, boolean ignoreLeadingDollarOrExclamation, int startIndex) {
        int checksum = 0;
        for (int i = startIndex; i < sentenceWithoutTagBlock.length(); ++i) {
            char ch = sentenceWithoutTagBlock.charAt(i);
            if (ignoreLeadingDollarOrExclamation && (ch == '$' || ch == '!')) continue;
            if (ch == '*') break;
            if (checksum == 0) {
                checksum = ch;
                continue;
            }
            checksum ^= ch;
        }
        return NmeaUtil.toUpperCaseHexString(checksum % 256);
    }

    private static String toUpperCaseHexString(int n) {
        return hexes[n];
    }

    public static NmeaMessage parseNmea(String line) {
        return NmeaUtil.parseNmea(line, false);
    }

    public static NmeaMessage parseNmea(String line, boolean validateChecksum) {
        return nmeaParser.parse(line, validateChecksum);
    }

    public static String insertKeyValueInTagBlock(String line, String name, String value) {
        if ((line = line.trim()).startsWith("\\")) {
            int i = line.indexOf(92, 1);
            if (i == -1) {
                return line;
            }
            if (i < 4) {
                return line;
            }
            String content = line.substring(1, i - 3);
            StringBuilder s = new StringBuilder(content);
            s.append(",");
            s.append(name);
            s.append(":");
            s.append(value);
            String checksum = NmeaUtil.getChecksum(s.toString(), false);
            s.append('*');
            s.append(checksum);
            s.append(line.substring(i));
            s.insert(0, '\\');
            return s.toString();
        }
        return line;
    }

    public static String supplementWithTime(String line, long arrivalTime) {
        String amendedLine;
        line = line.trim();
        NmeaMessage m = NmeaUtil.parseNmea(line);
        Long t = m.getUnixTimeMillis();
        Long a = m.getArrivalTimeMillis();
        if (t == null) {
            t = arrivalTime;
            if (line.startsWith("\\")) {
                int i = line.indexOf(92, 1);
                if (i == -1) {
                    throw new RuntimeException("line starts with \\ but does not have closing tag block delimiter \\");
                }
                if (i < 4) {
                    throw new RuntimeException("tag block not long enough to have a checksum");
                }
                String content = line.substring(1, i - 3);
                StringBuilder s = new StringBuilder(content);
                s.append(",");
                NmeaUtil.appendTimes(arrivalTime, t, s);
                String checksum = NmeaUtil.getChecksum(s.toString(), false);
                s.append('*');
                s.append(checksum);
                s.append(line.substring(i));
                s.insert(0, '\\');
                amendedLine = s.toString();
            } else {
                StringBuilder s = new StringBuilder();
                NmeaUtil.appendTimes(t, arrivalTime, s);
                String checksum = NmeaUtil.getChecksum(s.toString(), false);
                s.append("*");
                s.append(checksum);
                s.append('\\');
                s.append(line);
                s.insert(0, '\\');
                amendedLine = s.toString();
            }
        } else if (a == null) {
            int i = line.indexOf(92, 1);
            String content = line.substring(1, i - 3);
            StringBuilder s = new StringBuilder(content);
            s.append(",a:");
            s.append(arrivalTime);
            String checksum = NmeaUtil.getChecksum(s.toString(), false);
            s.append('*');
            s.append(checksum);
            s.append(line.substring(i));
            s.insert(0, '\\');
            amendedLine = s.toString();
        } else {
            amendedLine = line;
        }
        return amendedLine;
    }

    private static void appendTimes(long arrivalTime, Long t, StringBuilder s) {
        s.append("c:");
        s.append(t / 1000L);
        s.append(",a:");
        s.append(arrivalTime);
    }

    public static Talker getTalker(String s) {
        if (s == null) {
            return Talker.UNKNOWN;
        }
        Talker t = talkers.get(s);
        if (t == null) {
            return Talker.UNKNOWN;
        }
        return t;
    }

    public static String createTagBlock(LinkedHashMap<String, String> tags) {
        if (tags == null || tags.size() == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder(128);
        s.append("\\");
        int startChecksum = s.length();
        boolean first = true;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            if (!first) {
                s.append(",");
            }
            s.append(entry.getKey());
            s.append(":");
            s.append(entry.getValue());
            first = false;
        }
        String checksum = NmeaUtil.getChecksum(s.substring(startChecksum));
        s.append("*");
        s.append(checksum);
        s.append("\\");
        return s.toString();
    }

    public static String createNmeaLine(LinkedHashMap<String, String> tags, List<String> items) {
        StringBuilder s = new StringBuilder(40);
        s.append(NmeaUtil.createTagBlock(tags));
        int startForChecksum = s.length();
        boolean first = true;
        for (String item : items) {
            if (!first) {
                s.append(",");
            }
            s.append(item);
            first = false;
        }
        String checksum = NmeaUtil.getChecksum(s.substring(startForChecksum));
        s.append("*");
        s.append(checksum);
        return s.toString();
    }
}

