/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.util.SixBit;
import au.gov.amsa.util.SixBitException;

public class AisExtractor {
    private final boolean[] bitSet;
    private final boolean[] calculated;
    private final int padBits;
    private final String message;

    public AisExtractor(String message, Integer minLength, int padBits) {
        if (message.length() == 0) {
            throw new AisParseException("message length cannot be 0");
        }
        if (padBits > 6 || padBits < 0) {
            throw new AisParseException("padBits must be between 0 and 6");
        }
        this.message = message;
        boolean[] bits = new boolean[message.length() * 6 - padBits];
        boolean[] calculated = new boolean[message.length()];
        this.bitSet = bits;
        this.calculated = calculated;
        this.padBits = padBits;
        if (minLength != null && this.bitSet.length < minLength) {
            throw new AisParseException(AisParseException.NOT_CONSISTENT_DECODED_STRING + ", length was " + this.bitSet.length + " and should be >=" + minLength);
        }
    }

    public int getMessageId() {
        return this.getValue(0, 6);
    }

    public int getValue(int from, int to) {
        try {
            SixBit.convertSixBitToBits(this.message, this.padBits, this.bitSet, this.calculated, from, to);
            return (int)SixBit.getValue(from, to, this.bitSet);
        }
        catch (SixBitException | ArrayIndexOutOfBoundsException e) {
            throw new AisParseException(e);
        }
    }

    public int getSignedValue(int from, int to) {
        try {
            SixBit.convertSixBitToBits(this.message, this.padBits, this.bitSet, this.calculated, from, to);
            return (int)SixBit.getSignedValue(from, to, this.bitSet);
        }
        catch (SixBitException e) {
            throw new AisParseException(e);
        }
    }

    public String getString(int from, int to) {
        try {
            SixBit.convertSixBitToBits(this.message, this.padBits, this.bitSet, this.calculated, from, to);
            return SixBit.getString(from, to, this.bitSet);
        }
        catch (SixBitException e) {
            throw new AisParseException(e);
        }
    }
}

