/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AbstractAisBStaticDataReport;
import au.gov.amsa.ais.message.AisAidToNavigation;
import au.gov.amsa.ais.message.AisBStaticDataReportPartA;
import au.gov.amsa.ais.message.AisBStaticDataReportPartB;
import au.gov.amsa.ais.message.AisBaseStation;
import au.gov.amsa.ais.message.AisMessageOther;
import au.gov.amsa.ais.message.AisPositionA;
import au.gov.amsa.ais.message.AisPositionB;
import au.gov.amsa.ais.message.AisPositionBExtended;
import au.gov.amsa.ais.message.AisPositionGPS;
import au.gov.amsa.ais.message.AisShipStaticA;

public class AisMessageParser {
    private final AisExtractorFactory factory;

    public AisMessageParser() {
        this(Util.getAisExtractorFactory());
    }

    public AisMessageParser(AisExtractorFactory factory) {
        this.factory = factory;
    }

    public AisMessage parse(String message, int padBits) {
        return this.parse(message, null, padBits);
    }

    public AisMessage parse(String message, String source, int padBits) {
        AisExtractor extractor = this.factory.create(message, 0, padBits);
        int id = extractor.getMessageId();
        if (Util.isClassAPositionReport(id)) {
            return new AisPositionA(message, source, padBits);
        }
        if (id == 4) {
            return new AisBaseStation(message, source, padBits);
        }
        if (id == 5) {
            return new AisShipStaticA(message, source, padBits);
        }
        if (id == 18) {
            return new AisPositionB(message, source, padBits);
        }
        if (id == 19) {
            return new AisPositionBExtended(message, source, padBits);
        }
        if (id == 21) {
            return new AisAidToNavigation(message, source, padBits);
        }
        if (id == AisMessageType.STATIC_DATA_REPORT.getId()) {
            int partNumber = AbstractAisBStaticDataReport.extractPartNumber(this.factory, message, padBits);
            return this.parseStaticDataReport(partNumber, id, message, source, padBits);
        }
        if (id == 27) {
            return new AisPositionGPS(message, source, padBits);
        }
        return new AisMessageOther(id, source, padBits);
    }

    AisMessage parseStaticDataReport(int partNumber, int id, String message, String source, int padBits) {
        if (partNumber == 0) {
            return new AisBStaticDataReportPartA(message, source, padBits);
        }
        if (partNumber == 1) {
            return new AisBStaticDataReportPartB(message, source, padBits);
        }
        throw new AisParseException("Unsupported part number [" + partNumber + "]");
    }
}

