/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AbstractAisBStaticDataReport;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.Optional;

public class AisBStaticDataReportPartB
extends AbstractAisBStaticDataReport {
    private static final int MESSAGE_LENGTH = 168;
    private static final String CALL_SIGN_NOT_AVAILABLE = "@@@@@@@";
    private static final int DIMENSION_ZERO = 0;
    private final int shipType = AisBStaticDataReportPartB.extractShipType(this.getExtractor());
    private final String vendorManufacturerId = AisBStaticDataReportPartB.extractVendorManufacturerId(this.getExtractor());
    private final int vendorUnitModelCode = AisBStaticDataReportPartB.extractVendorUnitModelCode(this.getExtractor());
    private final int vendorUnitSerialNumber = AisBStaticDataReportPartB.extractVendorUnitSerialNumber(this.getExtractor());
    private final Optional<String> callsign = AisBStaticDataReportPartB.extractCallSign(this.getExtractor());
    private final Optional<Integer> dimensionA = AisBStaticDataReportPartB.extractDimensionA(this.getExtractor());
    private final Optional<Integer> dimensionB = AisBStaticDataReportPartB.extractDimensionB(this.getExtractor());
    private final Optional<Integer> dimensionC = AisBStaticDataReportPartB.extractDimensionC(this.getExtractor());
    private final Optional<Integer> dimensionD = AisBStaticDataReportPartB.extractDimensionD(this.getExtractor());

    public AisBStaticDataReportPartB(String message, int padBits) {
        this(message, null, padBits);
    }

    public AisBStaticDataReportPartB(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisBStaticDataReportPartB(AisExtractorFactory factory, String message, String source, int padBits) {
        super(1, factory, source, factory.create(message, 168, padBits));
    }

    @VisibleForTesting
    static int extractShipType(AisExtractor extractor) {
        return extractor.getValue(40, 48);
    }

    @VisibleForTesting
    static String extractVendorManufacturerId(AisExtractor extractor) {
        return extractor.getString(48, 66);
    }

    @VisibleForTesting
    static int extractVendorUnitModelCode(AisExtractor extractor) {
        return extractor.getValue(66, 70);
    }

    @VisibleForTesting
    static int extractVendorUnitSerialNumber(AisExtractor extractor) {
        return extractor.getValue(70, 90);
    }

    @VisibleForTesting
    static Optional<String> extractCallSign(AisExtractor extractor) {
        String value = extractor.getString(90, 132);
        if (CALL_SIGN_NOT_AVAILABLE.contentEquals(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @VisibleForTesting
    static Optional<Integer> extractDimensionA(AisExtractor extractor) {
        int value = extractor.getValue(132, 141);
        return value != 0 ? Optional.of(value) : Optional.empty();
    }

    @VisibleForTesting
    static Optional<Integer> extractDimensionB(AisExtractor extractor) {
        int value = extractor.getValue(141, 150);
        return value != 0 ? Optional.of(value) : Optional.empty();
    }

    @VisibleForTesting
    static Optional<Integer> extractDimensionC(AisExtractor extractor) {
        int value = extractor.getValue(150, 156);
        return value != 0 ? Optional.of(value) : Optional.empty();
    }

    @VisibleForTesting
    static Optional<Integer> extractDimensionD(AisExtractor extractor) {
        int value = extractor.getValue(156, 162);
        return value != 0 ? Optional.of(value) : Optional.empty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisPositionBStaticPartB [source=");
        builder.append(this.getSource());
        builder.append(", messageId=");
        builder.append(this.getMessageId());
        builder.append(", mmsi=");
        builder.append(this.getMmsi());
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", partNumber=");
        builder.append(this.getPartNumber());
        builder.append(", typeOfShipAndCargoType=");
        builder.append(this.getShipType());
        builder.append(", vendorManufacturerId=");
        builder.append(this.getVendorManufacturerId());
        builder.append(", vendorUnitModelCode=");
        builder.append(this.getVendorUnitModelCode());
        builder.append(", vendorUnitSerialNumber=");
        builder.append(this.getVendorUnitSerialNumber());
        builder.append(", callSign=");
        builder.append(this.getCallsign());
        builder.append(", dimensionA=");
        builder.append(this.getDimensionA());
        builder.append(", dimensionB=");
        builder.append(this.getDimensionB());
        builder.append(", dimensionC=");
        builder.append(this.getDimensionC());
        builder.append(", dimensionD=");
        builder.append(this.getDimensionD());
        builder.append("]");
        return builder.toString();
    }

    public int getShipType() {
        return this.shipType;
    }

    public Optional<String> getCallsign() {
        return this.callsign;
    }

    public Optional<Integer> getDimensionA() {
        if (this.dimensionA.orElse(0) == 0 && this.dimensionB.orElse(0) == 0) {
            return Optional.empty();
        }
        return this.dimensionA;
    }

    public Optional<Integer> getDimensionB() {
        if (this.dimensionA.orElse(0) == 0 && this.dimensionB.orElse(0) == 0) {
            return Optional.empty();
        }
        return this.dimensionB;
    }

    public Optional<Integer> getDimensionC() {
        if (this.dimensionC.orElse(0) == 0 && this.dimensionD.orElse(0) == 0) {
            return Optional.empty();
        }
        return this.dimensionC;
    }

    public Optional<Integer> getDimensionD() {
        if (this.dimensionC.orElse(0) == 0 && this.dimensionD.orElse(0) == 0) {
            return Optional.empty();
        }
        return this.dimensionD;
    }

    public Optional<Integer> getLengthMetres() {
        Optional<Integer> a = this.getDimensionA();
        if (!a.isPresent()) {
            return Optional.empty();
        }
        Optional<Integer> b = this.getDimensionB();
        if (!b.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(a.get() + b.get());
    }

    public Optional<Integer> getWidthMetres() {
        Optional<Integer> c = this.getDimensionC();
        if (!c.isPresent()) {
            return Optional.empty();
        }
        Optional<Integer> d = this.getDimensionD();
        if (!d.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(c.get() + d.get());
    }

    public String getVendorManufacturerId() {
        return this.vendorManufacturerId;
    }

    public Integer getVendorUnitModelCode() {
        return this.vendorUnitModelCode;
    }

    public Integer getVendorUnitSerialNumber() {
        return this.vendorUnitSerialNumber;
    }
}

