/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.HasMmsi;
import au.gov.amsa.ais.Util;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.Calendar;
import java.util.TimeZone;

public class AisBaseStation
implements AisMessage,
HasMmsi {
    @VisibleForTesting
    static final int MIN_LENGTH = 168;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;

    public AisBaseStation(String message, int padBits) {
        this(message, null, padBits);
    }

    public AisBaseStation(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisBaseStation(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 168, padBits);
        this.messageId = this.extractor.getMessageId();
        Util.checkMessageId(this.messageId, AisMessageType.BASE_STATION_REPORT);
        Util.checkLatLong(this.getLatitude(), this.getLongitude());
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    public int getRepeatIndicator() {
        return this.extractor.getValue(6, 8);
    }

    @Override
    public int getMmsi() {
        return this.extractor.getValue(8, 38);
    }

    public int getYear() {
        return this.extractor.getValue(38, 52);
    }

    public int getMonth() {
        return this.extractor.getValue(52, 56);
    }

    public int getDay() {
        return this.extractor.getValue(56, 61);
    }

    public int getHour() {
        return this.extractor.getValue(61, 66);
    }

    public int getMinute() {
        return this.extractor.getValue(66, 72);
    }

    public int getSecond() {
        return this.extractor.getValue(72, 78);
    }

    public int getPositionAccuracy() {
        return this.extractor.getValue(78, 79);
    }

    private long calculateTimestamp() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public long getTimestamp() {
        return this.calculateTimestamp();
    }

    public double getLatitude() {
        return (double)this.extractor.getSignedValue(107, 134) / 600000.0;
    }

    public double getLongitude() {
        return (double)this.extractor.getSignedValue(79, 107) / 600000.0;
    }

    public int getDeviceType() {
        return this.extractor.getValue(134, 138);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisBaseStation [source=");
        builder.append(this.source);
        builder.append(", year=");
        builder.append(this.getYear());
        builder.append(", messageId=");
        builder.append(this.messageId);
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", mmsi=");
        builder.append(this.getMmsi());
        builder.append(", month=");
        builder.append(this.getMonth());
        builder.append(", day=");
        builder.append(this.getDay());
        builder.append(", hour=");
        builder.append(this.getHour());
        builder.append(", minute=");
        builder.append(this.getMinute());
        builder.append(", second=");
        builder.append(this.getSecond());
        builder.append(", positionAccuracy=");
        builder.append(this.getPositionAccuracy());
        builder.append(", timestamp=");
        builder.append(this.getTimestamp());
        builder.append(", latitude=");
        builder.append(this.getLatitude());
        builder.append(", longitude=");
        builder.append(this.getLongitude());
        builder.append(", deviceType=");
        builder.append(this.getDeviceType());
        builder.append("]");
        return builder.toString();
    }
}

