/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.Communications;
import au.gov.amsa.ais.HasCommunications;
import au.gov.amsa.ais.HasNavigationalStatus;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AisPosition;
import au.gov.amsa.ais.message.NavigationalStatus;

public class AisPositionA
implements AisPosition,
HasCommunications,
HasNavigationalStatus {
    private static final Integer TRUE_HEADING_NOT_AVAILABLE = 511;
    private static final Integer COG_NOT_AVAILABLE = 3600;
    private static final Integer SOG_NOT_AVAILABLE = 1023;
    private static final Integer ROT_NOT_AVAILABLE = -128;
    private static final Integer LONGITUDE_NOT_AVAILABLE = 108600000;
    private static final Integer LATITUDE_NOT_AVAILABLE = 54600000;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;
    private final int mmsi;
    private final Double longitude;
    private final Double latitude;

    public AisPositionA(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisPositionA(String message, int padBits) {
        this(Util.getAisExtractorFactory(), message, null, padBits);
    }

    public AisPositionA(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 137, padBits);
        this.messageId = this.extractor.getMessageId();
        Util.checkMessageId(this.messageId, AisMessageType.POSITION_REPORT_SCHEDULED, AisMessageType.POSITION_REPORT_ASSIGNED, AisMessageType.POSITION_REPORT_SPECIAL);
        this.mmsi = this.extractor.getValue(8, 38);
        this.longitude = AisPositionA.extractLongitude(this.extractor);
        this.latitude = AisPositionA.extractLatitude(this.extractor);
    }

    static Integer extractTrueHeading(AisExtractor extractor) {
        try {
            int val = extractor.getValue(128, 137);
            if (val == TRUE_HEADING_NOT_AVAILABLE) {
                return null;
            }
            if (val > 359) {
                return null;
            }
            return val;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractCourseOverGround(AisExtractor extractor) {
        try {
            int val = extractor.getValue(116, 128);
            if (val == COG_NOT_AVAILABLE || val >= 3600) {
                return null;
            }
            return (double)val / 10.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractSpeedOverGround(AisExtractor extractor) {
        try {
            int val = extractor.getValue(50, 60);
            if (val == SOG_NOT_AVAILABLE) {
                return null;
            }
            return (double)val / 10.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Integer extractRateOfTurn(AisExtractor extractor) {
        try {
            byte val = (byte)extractor.getSignedValue(42, 50);
            if (val == ROT_NOT_AVAILABLE) {
                return null;
            }
            return val;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractLongitude(AisExtractor extractor) {
        try {
            int val = extractor.getSignedValue(61, 89);
            if (val == LONGITUDE_NOT_AVAILABLE) {
                return null;
            }
            Util.checkLong((double)val / 600000.0);
            return (double)val / 600000.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractLatitude(AisExtractor extractor) {
        try {
            int val = extractor.getSignedValue(89, 116);
            if (val == LATITUDE_NOT_AVAILABLE) {
                return null;
            }
            Util.checkLat((double)val / 600000.0);
            return (double)val / 600000.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public int getRepeatIndicator() {
        return this.extractor.getValue(6, 8);
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    @Override
    public NavigationalStatus getNavigationalStatus() {
        return NavigationalStatus.values()[this.extractor.getValue(38, 42)];
    }

    public Integer getRateOfTurn() {
        return AisPositionA.extractRateOfTurn(this.extractor);
    }

    @Override
    public Double getSpeedOverGroundKnots() {
        return AisPositionA.extractSpeedOverGround(this.extractor);
    }

    @Override
    public boolean isHighAccuracyPosition() {
        return Util.areEqual(this.extractor.getValue(60, 61), 1);
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public Double getCourseOverGround() {
        return AisPositionA.extractCourseOverGround(this.extractor);
    }

    @Override
    public Integer getTrueHeading() {
        return AisPositionA.extractTrueHeading(this.extractor);
    }

    @Override
    public int getTimeSecondsOnly() {
        return this.extractor.getValue(137, 143);
    }

    public int getSpecialManoeuvreIndicator() {
        return this.extractor.getValue(143, 145);
    }

    public int getSpare() {
        return this.extractor.getValue(145, 148);
    }

    @Override
    public boolean isUsingRAIM() {
        return Util.areEqual(this.extractor.getValue(148, 149), 1);
    }

    @Override
    public Communications getCommunications() {
        return new Communications(this.extractor, 149);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisPositionA [source=");
        builder.append(this.source);
        builder.append(", messageId=");
        builder.append(this.messageId);
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", mmsi=");
        builder.append(this.mmsi);
        builder.append(", navigationalStatus=");
        builder.append((Object)this.getNavigationalStatus());
        builder.append(", rateOfTurn=");
        builder.append(this.getRateOfTurn());
        builder.append(", speedOverGroundKnots=");
        builder.append(this.getSpeedOverGroundKnots());
        builder.append(", isHighAccuracyPosition=");
        builder.append(this.isHighAccuracyPosition());
        builder.append(", longitude=");
        builder.append(this.longitude);
        builder.append(", latitude=");
        builder.append(this.latitude);
        builder.append(", courseOverGround=");
        builder.append(this.getCourseOverGround());
        builder.append(", trueHeading=");
        builder.append(this.getTrueHeading());
        builder.append(", timeSecondsOnly=");
        builder.append(this.getTimeSecondsOnly());
        builder.append(", specialManoeuvreIndicator=");
        builder.append(this.getSpecialManoeuvreIndicator());
        builder.append(", spare=");
        builder.append(this.getSpare());
        builder.append(", isUsingRAIM=");
        builder.append(this.isUsingRAIM());
        builder.append(", communications=");
        builder.append(this.getCommunications());
        builder.append("]");
        return builder.toString();
    }
}

