/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.HasNavigationalStatus;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AisPosition;
import au.gov.amsa.ais.message.NavigationalStatus;

public class AisPositionGPS
implements AisPosition,
HasNavigationalStatus {
    private static final Integer COG_NOT_AVAILABLE = 511;
    private static final Integer SOG_NOT_AVAILABLE = 63;
    private static final Integer LONGITUDE_NOT_AVAILABLE = 108600;
    private static final Integer LATITUDE_NOT_AVAILABLE = 54600;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;
    private final int mmsi;
    private final Double longitude;
    private final Double latitude;

    public AisPositionGPS(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisPositionGPS(String message, int padBits) {
        this(message, null, padBits);
    }

    public AisPositionGPS(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 96, padBits);
        this.messageId = this.extractor.getMessageId();
        Util.checkMessageId(this.messageId, AisMessageType.POSITION_GPS);
        this.mmsi = this.extractor.getValue(8, 38);
        this.longitude = AisPositionGPS.extractLongitude(this.extractor);
        this.latitude = AisPositionGPS.extractLatitude(this.extractor);
    }

    static Double extractCourseOverGround(AisExtractor extractor) {
        try {
            int val = extractor.getValue(85, 94);
            if (val == COG_NOT_AVAILABLE || val >= 360) {
                return null;
            }
            return (double)val * 1.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractSpeedOverGround(AisExtractor extractor) {
        try {
            int val = extractor.getValue(79, 85);
            if (val == SOG_NOT_AVAILABLE) {
                return null;
            }
            return (double)val * 1.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractLongitude(AisExtractor extractor) {
        try {
            int val = extractor.getSignedValue(44, 62);
            if (val == LONGITUDE_NOT_AVAILABLE) {
                return null;
            }
            Util.checkLong((double)val / 600.0);
            return (double)val / 600.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    static Double extractLatitude(AisExtractor extractor) {
        try {
            int val = extractor.getSignedValue(62, 79);
            if (val == LATITUDE_NOT_AVAILABLE) {
                return null;
            }
            Util.checkLat((double)val / 600.0);
            return (double)val / 600.0;
        }
        catch (AisParseException e) {
            return null;
        }
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public int getRepeatIndicator() {
        return this.extractor.getValue(6, 8);
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    @Override
    public NavigationalStatus getNavigationalStatus() {
        return NavigationalStatus.values()[this.extractor.getValue(40, 44)];
    }

    @Override
    public Double getSpeedOverGroundKnots() {
        return AisPositionGPS.extractSpeedOverGround(this.extractor);
    }

    @Override
    public boolean isHighAccuracyPosition() {
        return Util.areEqual(this.extractor.getValue(38, 39), 1);
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public Double getCourseOverGround() {
        return AisPositionGPS.extractCourseOverGround(this.extractor);
    }

    @Override
    public Integer getTrueHeading() {
        return null;
    }

    @Override
    public int getTimeSecondsOnly() {
        return 0;
    }

    public int getSpare() {
        return this.extractor.getValue(95, 96);
    }

    @Override
    public boolean isUsingRAIM() {
        return Util.areEqual(this.extractor.getValue(39, 40), 1);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisPositionGPS [source=");
        builder.append(this.source);
        builder.append(", messageId=");
        builder.append(this.messageId);
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", mmsi=");
        builder.append(this.mmsi);
        builder.append(", navigationalStatus=");
        builder.append((Object)this.getNavigationalStatus());
        builder.append(", speedOverGroundKnots=");
        builder.append(this.getSpeedOverGroundKnots());
        builder.append(", isHighAccuracyPosition=");
        builder.append(this.isHighAccuracyPosition());
        builder.append(", longitude=");
        builder.append(this.longitude);
        builder.append(", latitude=");
        builder.append(this.latitude);
        builder.append(", courseOverGround=");
        builder.append(this.getCourseOverGround());
        builder.append(", trueHeading=");
        builder.append(this.getTrueHeading());
        builder.append(", timeSecondsOnly=");
        builder.append(this.getTimeSecondsOnly());
        builder.append(", spare=");
        builder.append(this.getSpare());
        builder.append(", isUsingRAIM=");
        builder.append(this.isUsingRAIM());
        builder.append("]");
        return builder.toString();
    }
}

