/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.parse;

public final class Util {
    private Util() {
    }

    public static int parseInt(String s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException("not a digit: " + ch);
            }
            result = result * 10 + ch - 48;
        }
        return result;
    }

    public static long parseLong(String s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new NumberFormatException("not a digit: " + ch);
            }
            result = result * 10L + (long)ch - 48L;
        }
        return result;
    }
}

