/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.rx;

import au.gov.amsa.ais.rx.CraftProperty;
import au.gov.amsa.ais.rx.CraftPropertyName;
import au.gov.amsa.ais.rx.Mmsi;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class CraftProperties {
    private final Map<CraftPropertyName, TreeMap<Long, String>> map;
    private final Mmsi mmsi;

    public CraftProperties(Mmsi mmsi, Map<CraftPropertyName, TreeMap<Long, String>> map) {
        this.mmsi = mmsi;
        this.map = map;
    }

    public CraftProperties(Mmsi mmsi) {
        this(mmsi, new HashMap<CraftPropertyName, TreeMap<Long, String>>());
    }

    public Map<CraftPropertyName, TreeMap<Long, String>> getMap() {
        return this.map;
    }

    public Mmsi getMmsi() {
        return this.mmsi;
    }

    public CraftProperties add(CraftProperty p) {
        HashMap<CraftPropertyName, TreeMap<Long, String>> m = new HashMap<CraftPropertyName, TreeMap<Long, String>>(this.map);
        if (m.get((Object)p.getName()) == null) {
            m.put(p.getName(), new TreeMap());
        }
        TreeMap tree = (TreeMap)m.get((Object)p.getName());
        Map.Entry before = tree.floorEntry(p.getTime());
        Map.Entry after = tree.ceilingEntry(p.getTime());
        if (before != null && ((String)before.getValue()).equals(p.getValue())) {
            return this;
        }
        if (after != null && ((String)after.getValue()).equals(p.getValue())) {
            tree.remove(after.getKey());
        }
        tree.put(p.getTime(), p.getValue());
        return new CraftProperties(this.mmsi, m);
    }
}

