/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.AisMessageParser;
import au.gov.amsa.ais.AisParseException;
import au.gov.amsa.ais.Timestamped;
import au.gov.amsa.ais.parse.Util;
import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaUtil;
import au.gov.amsa.util.nmea.Talker;

public class AisNmeaMessage {
    private static final AisMessageParser aisParser = new AisMessageParser(au.gov.amsa.ais.Util.getAisExtractorFactory());
    private final NmeaMessage nmea;
    private final String format;
    private final int fragmentCount;
    private final int fragmentNumber;
    private final String sequentialMessageId;
    private final String channel;
    private final String aisMessage;
    private final int padBits;

    public AisNmeaMessage(String line) {
        this(NmeaUtil.parseNmea(AisNmeaMessage.validateLine(line)));
    }

    public static AisNmeaMessage from(String line) {
        return new AisNmeaMessage(line);
    }

    private static String validateLine(String line) {
        try {
            if (!NmeaUtil.isValid(line)) {
                throw new AisParseException("invalid checksum: " + line + ", calculated checksum=" + NmeaUtil.getChecksum(line));
            }
            return line;
        }
        catch (RuntimeException e) {
            throw new AisParseException(e);
        }
    }

    public AisNmeaMessage(NmeaMessage nmea) {
        try {
            this.nmea = nmea;
            if (nmea.getItems().size() < 7) {
                throw new AisParseException("ais nmea line must have at least 7 columns:" + nmea.getItems());
            }
            this.format = this.getItem(0);
            this.fragmentCount = Util.parseInt(this.getItem(1));
            this.fragmentNumber = Util.parseInt(this.getItem(2));
            this.sequentialMessageId = this.getItem(3);
            this.channel = this.getItem(4);
            this.aisMessage = this.getItem(5);
            this.padBits = Integer.parseInt(nmea.getItems().get(6));
        }
        catch (RuntimeException e) {
            throw new AisParseException(e);
        }
    }

    public Long getTime() {
        return this.nmea.getUnixTimeMillis();
    }

    public Talker getTalker() {
        return this.nmea.getTalker();
    }

    private String getItem(int index) {
        return this.nmea.getItems().get(index);
    }

    public String getFormat() {
        return this.format;
    }

    public int getFragmentCount() {
        return this.fragmentCount;
    }

    public int getFragmentNumber() {
        return this.fragmentNumber;
    }

    public String getSequentialMessageId() {
        return this.sequentialMessageId;
    }

    public String getChannel() {
        return this.channel;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public AisMessage getMessage() {
        AisMessage m = aisParser.parse(this.aisMessage, this.nmea.getSource(), this.padBits);
        return m;
    }

    public Timestamped<AisMessage> getTimestampedMessage(long defaultTime) {
        Long time = this.getTime();
        if (time == null) {
            return Timestamped.create(this.getMessage(), defaultTime);
        }
        return Timestamped.create(this.getMessage(), this.getTime());
    }

    public Timestamped<AisMessage> getTimestampedMessage() {
        Long time = this.getTime();
        if (time == null) {
            return null;
        }
        return Timestamped.create(this.getMessage(), this.getTime());
    }

    public String getChecksum() {
        return this.nmea.getChecksum();
    }

    public NmeaMessage getNmea() {
        return this.nmea;
    }
}

