/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.math.BigInteger;

public final class ShipTypeDecoder {
    private static String[] vesselTypes = new String[]{"Fishing", "Towing", "Towing Long/Large", "Engaged in dredging or underwater operations", "Engaged in diving operations", "Engaged in military operations", "Sailing", "Pleasure craft", "Reserved", "Reserved"};
    private static String[] specialTypes = new String[]{"Pilot vessel", "SAR", "Tug", "Port tender", "Vessel with anti-pollution facilities or equipment", "Law enforcement", "Local 56", "Local 57", "Medical transport", "Ship according to RR Resolution No. 18 (Mob-83)"};
    private static String[] categoryTypes = new String[]{"Unknown", "Reserved", "WIG", "Vessel", "HSC", "Special", "Passenger ship", "Cargo ship", "Tanker", "Other"};
    private static String[] cargoTypes = new String[]{"All", "Carrying DG, HS, or MP, IMO Hazard or pollutant category A", "Carrying DG, HS, or MP, IMO Hazard or pollutant category B", "Carrying DG, HS, or MP, IMO Hazard or pollutant category C", "Carrying DG, HS, or MP, IMO Hazard or pollutant category D", "Reserved 5", "Reserved 6", "Reserved 7", "Reserved 8", "No additional info"};

    private ShipTypeDecoder() {
    }

    @VisibleForTesting
    static void forTestCoverageOnly() {
        new ShipTypeDecoder();
    }

    public static String getShipType(BigInteger ts) {
        if (ts == null) {
            return null;
        }
        return ShipTypeDecoder.getShipType(ts.intValue());
    }

    public static String getShipType(Integer ts) {
        if (ts == null) {
            return null;
        }
        if (ts < 10 || ts > 99) {
            return "unknown code " + ts;
        }
        int a = ts / 10;
        int b = ts % 10;
        if (a == 3) {
            return vesselTypes[b];
        }
        if (a == 5) {
            return specialTypes[b];
        }
        return categoryTypes[a] + " - " + cargoTypes[b];
    }

    public static void main(String[] args) {
        for (int i = 10; i <= 99; ++i) {
            System.out.println(i + "," + ShipTypeDecoder.getShipType(i));
        }
    }
}

