/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AbstractAisBStaticDataReport;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.Optional;

public class AisBStaticDataReportPartA
extends AbstractAisBStaticDataReport {
    private static final int MESSAGE_LENGTH = 160;
    private static final String NAME_NOT_AVAILABLE = "@@@@@@@@@@@@@@@@@@@@";
    private final Optional<String> name = AisBStaticDataReportPartA.extractName(this.getExtractor());

    public AisBStaticDataReportPartA(String message, int padBits) {
        this(message, null, padBits);
    }

    public AisBStaticDataReportPartA(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisBStaticDataReportPartA(AisExtractorFactory factory, String message, String source, int padBits) {
        super(0, factory, source, factory.create(message, 160, padBits));
    }

    @VisibleForTesting
    static Optional<String> extractName(AisExtractor extractor) {
        String value = extractor.getString(40, 160);
        if (NAME_NOT_AVAILABLE.contentEquals(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisPositionBStaticPartA [source=");
        builder.append(this.getSource());
        builder.append(", messageId=");
        builder.append(this.getMessageId());
        builder.append(", mmsi=");
        builder.append(this.getMmsi());
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", partNumber=");
        builder.append(this.getPartNumber());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append("]");
        return builder.toString();
    }
}

