/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.message;

import au.gov.amsa.ais.AisExtractor;
import au.gov.amsa.ais.AisExtractorFactory;
import au.gov.amsa.ais.AisMessageType;
import au.gov.amsa.ais.Util;
import au.gov.amsa.ais.message.AisPosition;
import au.gov.amsa.ais.message.AisShipStatic;
import java.util.Optional;

public class AisPositionBExtended
implements AisPosition,
AisShipStatic {
    private static final Integer TRUE_HEADING_NOT_AVAILABLE = 511;
    private static final Integer COG_NOT_AVAILABLE = 3600;
    private static final Integer SOG_NOT_AVAILABLE = 1023;
    private static final Integer LONGITUDE_NOT_AVAILABLE = 108600000;
    private static final Integer LATITUDE_NOT_AVAILABLE = 54600000;
    private final AisExtractor extractor;
    private final String source;
    private final int messageId;
    private final int repeatIndicator;
    private final int mmsi;
    private final Double speedOverGroundKnots;
    private final Double courseOverGround;
    private final Double latitude;
    private final Double longitude;
    private final Integer trueHeading;
    private final String name;
    private final int shipType;
    private final int dimensionA;
    private final int dimensionB;
    private final int dimensionC;
    private final int dimensionD;
    private final int timeSecondsOnly;
    private final boolean isHighAccuracyPosition;
    private final boolean isUsingRAIM;

    public AisPositionBExtended(String message, int padBits) {
        this(message, null, padBits);
    }

    public AisPositionBExtended(String message, String source, int padBits) {
        this(Util.getAisExtractorFactory(), message, source, padBits);
    }

    public AisPositionBExtended(AisExtractorFactory factory, String message, String source, int padBits) {
        this.source = source;
        this.extractor = factory.create(message, 301, padBits);
        this.messageId = this.extractor.getMessageId();
        Util.checkMessageId(this.getMessageId(), AisMessageType.POSITION_REPORT_CLASS_B_EXTENDED);
        this.repeatIndicator = this.extractor.getValue(6, 8);
        this.mmsi = this.extractor.getValue(8, 38);
        this.speedOverGroundKnots = AisPositionBExtended.extractSpeedOverGround(this.extractor);
        this.isHighAccuracyPosition = Util.areEqual(this.extractor.getValue(56, 57), 1);
        this.longitude = AisPositionBExtended.extractLongitude(this.extractor);
        this.latitude = AisPositionBExtended.extractLatitude(this.extractor);
        this.courseOverGround = AisPositionBExtended.extractCourseOverGround(this.extractor);
        this.trueHeading = AisPositionBExtended.extractTrueHeading(this.extractor);
        this.timeSecondsOnly = this.extractor.getValue(133, 139);
        this.name = this.extractor.getString(143, 263);
        this.shipType = this.extractor.getValue(263, 271);
        this.dimensionA = this.extractor.getValue(271, 280);
        this.dimensionB = this.extractor.getValue(280, 289);
        this.dimensionC = this.extractor.getValue(289, 295);
        this.dimensionD = this.extractor.getValue(295, 301);
        this.isUsingRAIM = Util.areEqual(this.extractor.getValue(305, 306), 1);
    }

    static Integer extractTrueHeading(AisExtractor extractor) {
        int val = extractor.getValue(124, 133);
        if (val == TRUE_HEADING_NOT_AVAILABLE) {
            return null;
        }
        return val;
    }

    static Double extractCourseOverGround(AisExtractor extractor) {
        int val = extractor.getValue(112, 124);
        if (val == COG_NOT_AVAILABLE) {
            return null;
        }
        return (double)val / 10.0;
    }

    static Double extractSpeedOverGround(AisExtractor extractor) {
        int val = extractor.getValue(46, 56);
        if (val == SOG_NOT_AVAILABLE) {
            return null;
        }
        return (double)val / 10.0;
    }

    static Double extractLongitude(AisExtractor extractor) {
        int val = extractor.getSignedValue(57, 85);
        if (val == LONGITUDE_NOT_AVAILABLE) {
            return null;
        }
        Util.checkLong((double)val / 600000.0);
        return (double)val / 600000.0;
    }

    static Double extractLatitude(AisExtractor extractor) {
        int val = extractor.getSignedValue(85, 112);
        if (val == LATITUDE_NOT_AVAILABLE) {
            return null;
        }
        Util.checkLat((double)val / 600000.0);
        return (double)val / 600000.0;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public int getRepeatIndicator() {
        return this.repeatIndicator;
    }

    @Override
    public int getMmsi() {
        return this.mmsi;
    }

    @Override
    public Double getSpeedOverGroundKnots() {
        return this.speedOverGroundKnots;
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public Double getCourseOverGround() {
        return this.courseOverGround;
    }

    @Override
    public Integer getTrueHeading() {
        return this.trueHeading;
    }

    @Override
    public int getTimeSecondsOnly() {
        return this.timeSecondsOnly;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getShipType() {
        return this.shipType;
    }

    @Override
    public Optional<Integer> getDimensionA() {
        if (this.dimensionA == 0) {
            return Optional.empty();
        }
        return Optional.of(this.dimensionA);
    }

    @Override
    public Optional<Integer> getDimensionB() {
        if (this.dimensionB == 0) {
            return Optional.empty();
        }
        return Optional.of(this.dimensionB);
    }

    @Override
    public Optional<Integer> getDimensionC() {
        if (this.dimensionC == 0) {
            return Optional.empty();
        }
        return Optional.of(this.dimensionC);
    }

    @Override
    public Optional<Integer> getDimensionD() {
        if (this.dimensionD == 0) {
            return Optional.empty();
        }
        return Optional.of(this.dimensionD);
    }

    @Override
    public Optional<Integer> getLengthMetres() {
        Optional<Integer> a = this.getDimensionA();
        if (!a.isPresent()) {
            return Optional.empty();
        }
        Optional<Integer> b = this.getDimensionB();
        if (!b.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(a.get() + b.get());
    }

    @Override
    public Optional<Integer> getWidthMetres() {
        Optional<Integer> c = this.getDimensionC();
        if (!c.isPresent()) {
            return Optional.empty();
        }
        Optional<Integer> d = this.getDimensionD();
        if (!d.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(c.get() + d.get());
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isHighAccuracyPosition() {
        return this.isHighAccuracyPosition;
    }

    @Override
    public boolean isUsingRAIM() {
        return this.isUsingRAIM;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AisPositionBExtended [source=");
        builder.append(this.source);
        builder.append(", messageId=");
        builder.append(this.messageId);
        builder.append(", mmsi=");
        builder.append(this.mmsi);
        builder.append(", repeatIndicator=");
        builder.append(this.getRepeatIndicator());
        builder.append(", speedOverGroundKnots=");
        builder.append(this.getSpeedOverGroundKnots());
        builder.append(", isHighAccuracyPosition=");
        builder.append(this.isHighAccuracyPosition());
        builder.append(", courseOverGround=");
        builder.append(this.getCourseOverGround());
        builder.append(", latitude=");
        builder.append(this.getLatitude());
        builder.append(", longitude=");
        builder.append(this.getLongitude());
        builder.append(", trueHeading=");
        builder.append(this.getTrueHeading());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", shipType=");
        builder.append(this.getShipType());
        builder.append(", dimensionA=");
        builder.append(this.getDimensionA());
        builder.append(", dimensionB=");
        builder.append(this.getDimensionB());
        builder.append(", dimensionC=");
        builder.append(this.getDimensionC());
        builder.append(", dimensionD=");
        builder.append(this.getDimensionD());
        builder.append(", timeSecondsOnly=");
        builder.append(this.getTimeSecondsOnly());
        builder.append("]");
        return builder.toString();
    }
}

