/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.rx;

import com.github.davidmoten.rx.Functions;
import java.io.IOException;
import java.io.OutputStream;
import rx.Observable;
import rx.functions.Func1;

public class RxUtil {
    public static <T> Func1<T, T> println(OutputStream out) {
        return t -> {
            try {
                out.write(t.toString().getBytes());
                out.write(10);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return t;
        };
    }

    public static <T> Func1<T, T> println() {
        return RxUtil.println(System.out);
    }

    public static <T> void print(Observable<T> o) {
        o.materialize().toBlocking().forEach(System.out::println);
    }

    public static <T> Observable<T> concatButIgnoreFirstSequence(Observable<?> o1, Observable<T> o2) {
        return Observable.concat((Observable)o1.filter(Functions.alwaysFalse()), o2);
    }
}

