/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.rx;

import au.gov.amsa.ais.rx.HostPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;

public class SocketReaderRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(SocketReaderRunnable.class);
    private final AtomicBoolean keepGoing = new AtomicBoolean(true);
    private final AtomicReference<Socket> socket = new AtomicReference<Object>(null);
    private final Observer<? super String> observer;
    private final AtomicReference<BufferedReader> reader = new AtomicReference();
    private final Object lock = new Object();
    private final HostPort hostPort;

    public SocketReaderRunnable(HostPort hostPort, Observer<? super String> observer) {
        this.hostPort = hostPort;
        this.observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BufferedReader br;
            log.info("creating new socket");
            Object object = this.lock;
            synchronized (object) {
                this.socket.set(SocketReaderRunnable.createSocket(this.hostPort.getHost(), this.hostPort.getPort()));
            }
            log.info("waiting one second before attempting connect");
            Thread.sleep(1000L);
            InputStream is = this.socket.get().getInputStream();
            Object object2 = this.lock;
            synchronized (object2) {
                br = new BufferedReader(new InputStreamReader(is));
                this.reader.set(br);
            }
            while (this.keepGoing.get()) {
                String line;
                Object object3 = this.lock;
                synchronized (object3) {
                    line = this.keepGoing.get() ? br.readLine() : null;
                }
                if (line != null) {
                    try {
                        this.observer.onNext((Object)line);
                    }
                    catch (RuntimeException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                this.keepGoing.set(false);
            }
            this.observer.onCompleted();
            log.info("completed");
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            this.observer.onError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.info("cancelling socket read");
        Object object = this.lock;
        synchronized (object) {
            this.keepGoing.set(false);
            if (this.socket.get() != null) {
                if (this.reader.get() != null) {
                    try {
                        this.reader.get().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    this.socket.get().close();
                    this.socket.set(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isCancelled() {
        return this.keepGoing.get();
    }

    private static Socket createSocket(String host, int port) {
        try {
            return new Socket(host, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

