/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.rx.operators;

import au.gov.amsa.ais.rx.CraftProperties;
import au.gov.amsa.ais.rx.CraftProperty;
import au.gov.amsa.ais.rx.Mmsi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.Subscriber;

public class OperatorCraftPropertAggregator
implements Observable.Operator<Map<Mmsi, CraftProperties>, CraftProperty> {
    private final ConcurrentHashMap<Mmsi, CraftProperties> map = new ConcurrentHashMap();

    public Subscriber<? super CraftProperty> call(final Subscriber<? super Map<Mmsi, CraftProperties>> child) {
        return new Subscriber<CraftProperty>(child){

            public void onCompleted() {
                if (this.isUnsubscribed()) {
                    return;
                }
                child.onNext((Object)OperatorCraftPropertAggregator.this.map);
            }

            public void onError(Throwable e) {
                if (!this.isUnsubscribed()) {
                    child.onError(e);
                }
            }

            public void onNext(CraftProperty p) {
                CraftProperties v;
                OperatorCraftPropertAggregator.this.map.putIfAbsent(p.getMmsi(), new CraftProperties(p.getMmsi()));
                do {
                    v = (CraftProperties)OperatorCraftPropertAggregator.this.map.get(p.getMmsi());
                } while (!OperatorCraftPropertAggregator.this.map.replace(p.getMmsi(), v, v.add(p)));
            }
        };
    }
}

