/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.ais.rx.operators;

import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.HasMmsi;
import au.gov.amsa.ais.Timestamped;
import au.gov.amsa.ais.message.AisPositionBExtended;
import au.gov.amsa.ais.message.AisShipStaticA;
import au.gov.amsa.ais.rx.CraftProperty;
import au.gov.amsa.ais.rx.CraftPropertyName;
import au.gov.amsa.ais.rx.Mmsi;
import rx.Observable;
import rx.Subscriber;

public class OperatorCraftProperty
implements Observable.Operator<CraftProperty, Timestamped<? extends AisMessage>> {
    public Subscriber<? super Timestamped<? extends AisMessage>> call(final Subscriber<? super CraftProperty> child) {
        return new Subscriber<Timestamped<? extends AisMessage>>(child){

            public void onCompleted() {
                if (!this.isUnsubscribed()) {
                    child.onCompleted();
                }
            }

            public void onError(Throwable e) {
                if (!this.isUnsubscribed()) {
                    child.onError(e);
                }
            }

            public void onNext(Timestamped<? extends AisMessage> m) {
                if (m.message() instanceof AisShipStaticA) {
                    this.handleShipStatic(m, (Subscriber<? super CraftProperty>)child);
                } else if (m.message() instanceof AisPositionBExtended) {
                    this.handleAisPositionBExtended(m, (Subscriber<? super CraftProperty>)child);
                }
            }

            private void handleShipStatic(Timestamped<AisShipStaticA> m, Subscriber<? super CraftProperty> child2) {
                this.handleProperty(child2, m, CraftPropertyName.CALLSIGN, m.message().getCallsign());
                this.handleProperty(child2, m, CraftPropertyName.DESTINATION, m.message().getDestination());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_A, m.message().getDimensionA());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_B, m.message().getDimensionB());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_C, m.message().getDimensionC());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_D, m.message().getDimensionD());
                this.handleProperty(child2, m, CraftPropertyName.IMO_NUMBER, m.message().getImo());
                this.handleProperty(child2, m, CraftPropertyName.LENGTH_METRES, m.message().getLengthMetres());
                this.handleProperty(child2, m, CraftPropertyName.DRAUGHT_METRES, m.message().getMaximumPresentStaticDraughtMetres());
                this.handleProperty(child2, m, CraftPropertyName.NAME, m.message().getName());
                this.handleProperty(child2, m, CraftPropertyName.SHIP_TYPE, m.message().getShipType());
                this.handleProperty(child2, m, CraftPropertyName.WIDTH_METRES, m.message().getWidthMetres());
            }

            private void handleAisPositionBExtended(Timestamped<AisPositionBExtended> m, Subscriber<? super CraftProperty> child2) {
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_A, m.message().getDimensionA());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_B, m.message().getDimensionB());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_C, m.message().getDimensionC());
                this.handleProperty(child2, m, CraftPropertyName.DIMENSION_D, m.message().getDimensionD());
                this.handleProperty(child2, m, CraftPropertyName.LENGTH_METRES, m.message().getLengthMetres());
                this.handleProperty(child2, m, CraftPropertyName.NAME, m.message().getName());
                this.handleProperty(child2, m, CraftPropertyName.SHIP_TYPE, m.message().getShipType());
                this.handleProperty(child2, m, CraftPropertyName.WIDTH_METRES, m.message().getWidthMetres());
            }

            private <R extends AisMessage & HasMmsi> void handleProperty(Subscriber<? super CraftProperty> child2, Timestamped<R> m, CraftPropertyName name, Object value) {
                if (!this.isUnsubscribed() && value != null) {
                    child2.onNext((Object)new CraftProperty(new Mmsi(((HasMmsi)m.message()).getMmsi()), name, value.toString(), m.time()));
                }
            }
        };
    }
}

