/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util;

import au.gov.amsa.util.SixBitException;

public final class SixBit {
    private static final int[] INT_TO_SIX_BIT = SixBit.createIntToSixBit();

    private static int[] createIntToSixBit() {
        int[] toSixbit = new int[65536];
        for (int chr = 0; chr < toSixbit.length; ++chr) {
            toSixbit[chr] = chr < 48 || chr > 119 || chr > 87 && chr < 96 ? -1 : (chr < 96 ? chr - 48 & 0x3F : chr - 56 & 0x3F);
        }
        return toSixbit;
    }

    public static void convertSixBitToBits(String str, int padBits, boolean[] bitSet, boolean[] calculated, int from, int to) {
        if (str.length() == 0) {
            return;
        }
        int index = from - from % 6;
        int strFrom = from / 6;
        int slen = str.length() - 1;
        int strTo = to / 6 + 1;
        for (int i = strFrom; i < Math.min(strTo, slen); ++i) {
            if (!calculated[i]) {
                char chr = str.charAt(i);
                int binVal = INT_TO_SIX_BIT[chr];
                if (binVal == -1) {
                    throw new SixBitException("Illegal sixbit ascii char: " + chr);
                }
                bitSet[index] = (binVal & 0x20) > 0;
                bitSet[index + 1] = (binVal & 0x10) > 0;
                bitSet[index + 2] = (binVal & 8) > 0;
                bitSet[index + 3] = (binVal & 4) > 0;
                bitSet[index + 4] = (binVal & 2) > 0;
                bitSet[index + 5] = (binVal & 1) > 0;
                calculated[i] = true;
            }
            index += 6;
        }
        if (strTo > slen) {
            char chr = str.charAt(slen);
            int binVal = INT_TO_SIX_BIT[chr];
            if (binVal == -1) {
                throw new SixBitException("Illegal sixbit ascii char: " + chr);
            }
            int bits = 6 - padBits;
            switch (bits) {
                case 6: {
                    bitSet[index + 5] = (binVal & 1) > 0;
                }
                case 5: {
                    bitSet[index + 4] = (binVal & 2) > 0;
                }
                case 4: {
                    bitSet[index + 3] = (binVal & 4) > 0;
                }
                case 3: {
                    bitSet[index + 2] = (binVal & 8) > 0;
                }
                case 2: {
                    bitSet[index + 1] = (binVal & 0x10) > 0;
                }
                case 1: {
                    bitSet[index] = (binVal & 0x20) > 0;
                }
            }
            calculated[slen] = true;
        }
    }

    public static long getValue(int from, int to, boolean[] bitSet) {
        if (to > bitSet.length) {
            throw new SixBitException(bitSet.length + " is not enough bits. At least " + to + " expected.");
        }
        long val = 0L;
        long powMask = 1L;
        for (int i = to - 1; i >= from; --i) {
            if (bitSet[i]) {
                val += powMask;
            }
            powMask <<= 1;
        }
        return val;
    }

    public static long getSignedValue(int from, int to, boolean[] bitSet) {
        if (to > bitSet.length) {
            throw new SixBitException(bitSet.length + " is not enough bits. At least " + to + " expected.");
        }
        long val = 0L;
        long powMask = 1L;
        for (int i = to - 1; i >= from; --i) {
            if (bitSet[i]) {
                val += powMask;
            }
            powMask <<= 1;
        }
        if (bitSet[from]) {
            val -= powMask;
        }
        return val;
    }

    public static String getString(int from, int to, boolean[] bitSet) {
        int len = (to - from) / 6;
        char[] resStr = new char[len];
        int pos = from;
        for (int i = 0; i < len; ++i) {
            char ch = (char)SixBit.intToAscii((char)SixBit.getValue(pos, pos + 6, bitSet));
            if (ch == '@') {
                len = i;
                break;
            }
            resStr[i] = ch;
            pos += 6;
        }
        while (len > 0 && resStr[len - 1] == ' ') {
            --len;
        }
        return new String(resStr, 0, len);
    }

    private static int intToAscii(int val) {
        if (val > 63) {
            throw new SixBitException("Char value " + val + " not allowed");
        }
        if (val < 32) {
            return val + 64;
        }
        return val;
    }
}

