/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea;

import au.gov.amsa.util.nmea.NmeaMessage;
import au.gov.amsa.util.nmea.NmeaMessageParseException;
import au.gov.amsa.util.nmea.NmeaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class NmeaMessageParser {
    private static final String CHECKSUM_DELIMITER = "*";
    private static final char PARAMETER_DELIMITER = ',';
    private static final String CODE_DELIMITER = ":";

    public NmeaMessage parse(String line) {
        return this.parse(line, false);
    }

    public NmeaMessage parse(String line, boolean validateChecksum) {
        String checksum;
        List<String> items;
        String remaining;
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        if (line.startsWith("\\")) {
            int tagFinish = line.lastIndexOf(92, line.length() - 1);
            if (tagFinish == -1) {
                throw new NmeaMessageParseException("no matching \\ symbol to finish tag block: " + line);
            }
            if (tagFinish == 0) {
                throw new NmeaMessageParseException("tag block is empty or not terminated");
            }
            tags = NmeaMessageParser.extractTags(line.substring(1, tagFinish));
            remaining = line.substring(tagFinish + 1);
        } else {
            remaining = line;
        }
        if (remaining.length() > 0) {
            String calculatedChecksum;
            if (!remaining.contains(CHECKSUM_DELIMITER)) {
                throw new NmeaMessageParseException("checksum delimiter * not found");
            }
            items = NmeaMessageParser.getNmeaItems(remaining);
            checksum = remaining.substring(remaining.indexOf(42) + 1).trim();
            if (validateChecksum && !checksum.equals(calculatedChecksum = NmeaUtil.getChecksumWhenHasNoTagBlock(remaining))) {
                throw new NmeaMessageParseException("stated checksum does not match calculated");
            }
        } else {
            items = Collections.emptyList();
            checksum = "";
        }
        return new NmeaMessage(tags, items, checksum);
    }

    private static List<String> getNmeaItems(String line) {
        List<String> items = NmeaMessageParser.splitBy(line, ',');
        String last = items.get(items.size() - 1);
        if (last.contains(CHECKSUM_DELIMITER)) {
            items.set(items.size() - 1, last.substring(0, last.lastIndexOf(42)));
        }
        return items;
    }

    private static List<String> splitBy(String s, char delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != delimiter) continue;
            list.add(s.substring(start, i));
            start = i + 1;
        }
        list.add(s.substring(start, s.length()));
        return list;
    }

    public static LinkedHashMap<String, String> extractTags(String s) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int c = s.lastIndexOf(CHECKSUM_DELIMITER);
        if (c == -1) {
            return map;
        }
        s = s.substring(0, c);
        List<String> items = NmeaMessageParser.splitBy(s, ',');
        for (String item : items) {
            int i = item.indexOf(CODE_DELIMITER);
            if (i == -1) {
                throw new NmeaMessageParseException("TAG BLOCK parameter is not is format 'a:b' :" + s);
            }
            map.put(item.substring(0, i), item.substring(i + 1));
        }
        return map;
    }
}

