/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea;

import au.gov.amsa.ais.rx.Streams;
import au.gov.amsa.util.nmea.NmeaReader;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NmeaReaderFromSocket
implements NmeaReader {
    private static Logger log = LoggerFactory.getLogger(NmeaReaderFromSocket.class);
    private final Socket socket;

    public NmeaReaderFromSocket(String host, int port) {
        this(NmeaReaderFromSocket.createSocket(host, port));
    }

    private static Socket createSocket(String host, int port) {
        try {
            return new Socket(host, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    NmeaReaderFromSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public Iterable<String> read() {
        try {
            return Streams.nmeaFrom(this.socket.getInputStream()).toBlocking().toIterable();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

