/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.util.nmea.saver;

import au.gov.amsa.util.nmea.NmeaUtil;
import au.gov.amsa.util.nmea.saver.Clock;
import au.gov.amsa.util.nmea.saver.FileFactory;
import au.gov.amsa.util.nmea.saver.SystemClock;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Schedulers;

public class NmeaSaver {
    private static Logger log = LoggerFactory.getLogger(NmeaSaver.class);
    private volatile Subscriber<String> subscriber;
    private final FileFactory factory;
    private final Observable<String> source;
    private final Clock clock;

    @VisibleForTesting
    NmeaSaver(Observable<String> nmea, FileFactory factory, Clock clock) {
        this.source = nmea;
        this.factory = factory;
        this.clock = clock;
    }

    public NmeaSaver(Observable<String> nmea, FileFactory factory) {
        this(nmea, factory, new SystemClock());
    }

    public void start() {
        this.start(Schedulers.io());
    }

    public void start(Scheduler scheduler) {
        this.subscriber = NmeaSaver.createSubscriber(this.factory, this.clock);
        this.source.subscribeOn(scheduler).subscribe(this.subscriber);
    }

    public void stop() {
        if (this.subscriber != null) {
            this.subscriber.unsubscribe();
        }
    }

    private static Subscriber<String> createSubscriber(final FileFactory factory, final Clock clock) {
        return new Subscriber<String>(){
            Optional<BufferedWriter> current = Optional.empty();
            Optional<String> currentKey = Optional.empty();
            boolean firstLineInFile = true;

            public void onCompleted() {
                log.warn("should not complete");
                this.closeCurrentWriter();
            }

            public void onError(Throwable e) {
                log.error(e.getMessage(), e);
                this.closeCurrentWriter();
            }

            private void closeCurrentWriter() {
                if (this.current.isPresent()) {
                    try {
                        this.current.get().close();
                    }
                    catch (IOException e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            }

            public void onNext(String line) {
                try {
                    long now = clock.getTimeMs();
                    String amendedLine = NmeaUtil.supplementWithTime(line, now);
                    String fileKey = factory.key(amendedLine, now);
                    if (!this.currentKey.isPresent() || !fileKey.equals(this.currentKey.get())) {
                        File file;
                        if (this.current.isPresent()) {
                            this.current.get().close();
                        }
                        this.firstLineInFile = !(file = factory.file(amendedLine, now)).exists();
                        this.current = Optional.of(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true))));
                        this.currentKey = Optional.of(fileKey);
                    }
                    if (!this.firstLineInFile) {
                        this.current.get().write(10);
                    }
                    this.firstLineInFile = false;
                    this.current.get().write(amendedLine);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
    }
}

