/*
 * Copyright 2011 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package au.gov.nehta.model.cda.common.time;

import au.net.electronichealth.ns.cda._2_0.SetOperator;

/**
 * SetComponentTime
	 Created to model CDA SetComponent time or SXCM_TS <br> 
	 A set of points in time, specifying the timing of events and actions and the
	 cyclical validity-patterns that may exist for certain kinds of information, such as phone
	 numbers (evening, daytime), addresses (so called "snowbirds," residing closer to the
	 equator during winter and farther from the equator during summer) and office hours.
 * <p>
 * this implementation contains a value and an operator
 * the value must be a date with the precision specified
 *  
 * the operator is as described below 
 *
 * <pre>
	I -  include Form the union with the value.
	E exclude Form the set-difference.
	A intersect Form the intersection with the value.
	H convex
	hull
	Form the convex hull with the value. The convex hull is
	defined over ordered domains and is the smallest
	contiguous superset (interval) that of all the operand sets.
	P periodic
	hull
	Form the periodic hull with the value. The periodic hull is
	defined over ordered domains and is the periodic set that
	contains all contiguous supersets of pairs of intervals
	generated by the operand periodic intervals.
  
   </pre>
 * @author NeHTA
 * 
 * @see EventRelatedTimeInterval (EIVL_TS)
 * @see RestrictedTimeInterval (IVL_TS)
 * @see RestrictedTimeInterval (IVL_TS) 
 *
 */
public class SetComponentTime extends CDATimeStamp {

	protected SetOperator operator;

	private String narrative;
	
	
	public SetComponentTime() {	}
	
	public SetComponentTime(PreciseDate value) {
		this.value=value;
	}
	
	public SetComponentTime(PreciseDate value, SetOperator operator) {
		this.value=value;
		this.operator=operator;
	}
	
	public String getNarrative() {
		return narrative;
	}

	public void setNarrative( String narrative ) {
		this.narrative = narrative;
	}

	public SetOperator getOperator() {
		return operator;
	}

	public void setOperator( SetOperator operator ) {
		this.operator = operator;
	}
	

}
