/*
 * Decompiled with CFR 0.152.
 */
package au.id.ajlane.iostreams.examples;

import au.id.ajlane.iostreams.FileLineIOStream;
import au.id.ajlane.iostreams.FilterDecision;
import au.id.ajlane.iostreams.IOStreamException;
import au.id.ajlane.iostreams.IOStreams;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class LineReadingExample {
    public static void main(String ... args) throws IOStreamException {
        IOStreams.fromArray((Object[])args).flatMap(file -> FileLineIOStream.fromFile((Path)Paths.get(file, new String[0]), (Charset)StandardCharsets.UTF_8)).filter(line -> {
            if (!line.text.matches("\\s*(#.*)?")) {
                return FilterDecision.KEEP_AND_CONTINUE;
            }
            return FilterDecision.SKIP_AND_CONTINUE;
        }).map(line -> line.path + "\t" + line.number + "\t" + line.text.replaceAll("^\\s+|\\s*#.*$", "")).foreach(System.out::println);
    }

    private LineReadingExample() {
    }
}

