/*
 * Decompiled with CFR 0.152.
 */
package au.id.tmm.githubprlanguagedetection.github;

import au.id.tmm.githubprlanguagedetection.github.PullRequestLister$;
import au.id.tmm.githubprlanguagedetection.github.configuration.GitHubConfiguration;
import au.id.tmm.githubprlanguagedetection.github.configuration.GitHubCredentials;
import au.id.tmm.githubprlanguagedetection.github.configuration.GitHubCredentials$Anonymous$;
import au.id.tmm.githubprlanguagedetection.github.configuration.GitHubInstance;
import au.id.tmm.githubprlanguagedetection.github.configuration.GitHubInstance$GitHubDotCom$;
import au.id.tmm.githubprlanguagedetection.github.model.Commit;
import au.id.tmm.githubprlanguagedetection.github.model.PullRequest;
import au.id.tmm.githubprlanguagedetection.github.model.Repository;
import au.id.tmm.githubprlanguagedetection.github.model.RepositoryName;
import au.id.tmm.utilities.errors.GenericException$;
import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.syntax.package;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import mouse.JvmStringOps$;
import mouse.package;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.EvidenceIterableFactory;
import scala.collection.EvidenceIterableFactory$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006\u0015\u0002!Ia\u0013\u0005\u0006+\u0002!IA\u0016\u0005\u0006s\u0002!IA\u001f\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\tI\u0002\u0001C\u0005\u000379q!a\u000f\u0010\u0011\u0003\tiD\u0002\u0004\u000f\u001f!\u0005\u0011q\b\u0005\u0007Q)!\t!!\u0011\t\u0013\u0005\r#B1A\u0005\n\u0005\u0015\u0003\u0002CA*\u0015\u0001\u0006I!a\u0012\u0003#A+H\u000e\u001c*fcV,7\u000f\u001e'jgR,'O\u0003\u0002\u0011#\u00051q-\u001b;ik\nT!AE\n\u00023\u001dLG\u000f[;caJd\u0017M\\4vC\u001e,G-\u001a;fGRLwN\u001c\u0006\u0003)U\t1\u0001^7n\u0015\t1r#\u0001\u0002jI*\t\u0001$\u0001\u0002bk\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006\u0019r-\u001b;Ik\n\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u00111EJ\u0007\u0002I)\u0011QeD\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005\u001d\"#aE$ji\"+(mQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002+YA\u00111\u0006A\u0007\u0002\u001f!)\u0011E\u0001a\u0001E\u0005\u0019B.[:u!VdGNU3rk\u0016\u001cHo\u001d$peR\u0011q&\u0012\t\u0004aU:T\"A\u0019\u000b\u0005I\u001a\u0014AB3gM\u0016\u001cGOC\u00015\u0003\u0011\u0019\u0017\r^:\n\u0005Y\n$AA%P!\rAThP\u0007\u0002s)\u0011!hO\u0001\nS6lW\u000f^1cY\u0016T!\u0001P\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002?s\tA\u0011I\u001d:bsN+\u0017\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u001f\u0005)Qn\u001c3fY&\u0011A)\u0011\u0002\f!VdGNU3rk\u0016\u001cH\u000fC\u0003G\u0007\u0001\u0007q)\u0001\bsKB|7/\u001b;peft\u0015-\\3\u0011\u0005\u0001C\u0015BA%B\u00059\u0011V\r]8tSR|'/\u001f(b[\u0016\f!\"\\1lK\u000ec\u0017.\u001a8u+\u0005a\u0005CA'T\u001b\u0005q%B\u0001\tP\u0015\t\u0001\u0016+A\u0004l_\"\u001cXo[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!fJ\u0001\u0004HSRDUOY\u0001\u0011a\u0006\u00148/\u001a)vY2\u0014V-];fgR$2aV8u!\rAFn\u0010\b\u00033&t!A\u00174\u000f\u0005m#gB\u0001/d\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002a3\u00051AH]8pizJ\u0011\u0001G\u0005\u0003-]I!\u0001F\u000b\n\u0005\u0015\u001c\u0012!C;uS2LG/[3t\u0013\t9\u0007.\u0001\u0004feJ|'o\u001d\u0006\u0003KNI!A[6\u0002\u000fA\f7m[1hK*\u0011q\r[\u0005\u0003[:\u00141\"\u0012=dKB$\u0018n\u001c8Pe*\u0011!n\u001b\u0005\u0006a\u0016\u0001\r!]\u0001\u0011a\u0006\u00148/\u001a3SKB|7/\u001b;pef\u0004\"\u0001\u0011:\n\u0005M\f%A\u0003*fa>\u001c\u0018\u000e^8ss\")Q/\u0002a\u0001m\u0006)\u0011\r]5Q%B\u0011Qj^\u0005\u0003q:\u0013Qb\u0012%Qk2d'+Z9vKN$\u0018a\u00039beN,7i\\7nSR$\"a_@\u0011\u0007acG\u0010\u0005\u0002A{&\u0011a0\u0011\u0002\u0007\u0007>lW.\u001b;\t\u000f\u0005\u0005a\u00011\u0001\u0002\u0004\u0005I\u0011\r]5D_6l\u0017\u000e\u001e\t\u0004\u001b\u0006\u0015\u0011bAA\u0004\u001d\nyq\tS\"p[6LG\u000fU8j]R,'/A\bqCJ\u001cXMU3q_NLGo\u001c:z)\u0011\ti!a\u0004\u0011\u0007ac\u0017\u000fC\u0004\u0002\u0012\u001d\u0001\r!a\u0005\u0002\u0015I,\u0007o\\:ji>\u0014\u0018\u0010E\u0002N\u0003+I1!a\u0006O\u000519\u0005JU3q_NLGo\u001c:z\u00039\u0011X-];je\u0016tuN\u001c(vY2,B!!\b\u0002&Q!\u0011qDA\u001c!\u0011AF.!\t\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t\u001d\t9\u0003\u0003b\u0001\u0003S\u0011\u0011!Q\t\u0005\u0003W\t\t\u0004E\u0002\u001d\u0003[I1!a\f\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001HA\u001a\u0013\r\t)$\b\u0002\u0004\u0003:L\bbBA\u001d\u0011\u0001\u0007\u0011\u0011E\u0001\u0002C\u0006\t\u0002+\u001e7m%\u0016\fX/Z:u\u0019&\u001cH/\u001a:\u0011\u0005-R1C\u0001\u0006\u001c)\t\ti$\u0001\u0004M\u001f\u001e;UIU\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\n\u0016!B:mMRR\u0017\u0002BA)\u0003\u0017\u0012a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000b\t")
public class PullRequestLister {
    private final GitHubConfiguration gitHubConfiguration;

    public IO<ArraySeq<PullRequest>> listPullRequestsFor(RepositoryName repositoryName) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> this.makeClient()).flatMap((Function1 & Serializable)client -> IO$.MODULE$.apply((Function0 & Serializable)() -> client.getRepository(repositoryName.asString())).flatMap((Function1 & Serializable)apiRepository -> IO$.MODULE$.apply((Function0 & Serializable)() -> (ArraySeq)CollectionConverters$.MODULE$.ListHasAsScala(apiRepository.getPullRequests(GHIssueState.ALL)).asScala().to(EvidenceIterableFactory$.MODULE$.toFactory((EvidenceIterableFactory)ArraySeq$.MODULE$, (Object)ClassTag$.MODULE$.apply(GHPullRequest.class)))).flatMap((Function1 & Serializable)apiPullRequests -> IO$.MODULE$.fromEither(this.parseRepository((GHRepository)apiRepository)).flatMap((Function1 & Serializable)parsedRepository -> IO$.MODULE$.fromEither((Either)package.traverse$.MODULE$.toTraverseOps(apiPullRequests, UnorderedFoldable$.MODULE$.catsTraverseForArraySeq()).traverse((Function1 & Serializable)pr -> this.parsePullRequest((Repository)parsedRepository, (GHPullRequest)pr), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).flatMap((Function1 & Serializable)parsedPullRequests -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> PullRequestLister$.MODULE$.au$id$tmm$githubprlanguagedetection$github$PullRequestLister$$LOGGER().info(new StringBuilder(16).append("Listed ").append(parsedPullRequests.size()).append(" PRs for ").append(repositoryName.asString()).toString())).map((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            ArraySeq arraySeq = (ArraySeq)parsedPullRequests.sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.number()), (Ordering)Ordering.Int$.MODULE$);
            return arraySeq;
        }))))));
    }

    private GitHub makeClient() {
        GitHubBuilder gitHubBuilder;
        GitHubBuilder gitHubBuilder2;
        GitHubBuilder clientBuilder = new GitHubBuilder();
        GitHubInstance gitHubInstance = this.gitHubConfiguration.instance();
        if (GitHubInstance$GitHubDotCom$.MODULE$.equals(gitHubInstance)) {
            gitHubBuilder2 = clientBuilder;
        } else if (gitHubInstance instanceof GitHubInstance.GitHubEnterprise) {
            GitHubInstance.GitHubEnterprise gitHubEnterprise = (GitHubInstance.GitHubEnterprise)gitHubInstance;
            URI base = gitHubEnterprise.base();
            gitHubBuilder2 = clientBuilder.withEndpoint(base.toString());
        } else {
            throw new MatchError((Object)gitHubInstance);
        }
        clientBuilder = gitHubBuilder2;
        GitHubCredentials gitHubCredentials = this.gitHubConfiguration.credentials();
        if (GitHubCredentials$Anonymous$.MODULE$.equals(gitHubCredentials)) {
            gitHubBuilder = clientBuilder;
        } else if (gitHubCredentials instanceof GitHubCredentials.AccessToken) {
            GitHubCredentials.AccessToken accessToken = (GitHubCredentials.AccessToken)gitHubCredentials;
            String username = accessToken.username();
            String token = accessToken.token();
            gitHubBuilder = clientBuilder.withPassword(username, token);
        } else {
            throw new MatchError((Object)gitHubCredentials);
        }
        clientBuilder = gitHubBuilder;
        return clientBuilder.build();
    }

    private Either<Exception, PullRequest> parsePullRequest(Repository parsedRepository, GHPullRequest apiPR) {
        return this.requireNonNull(BoxesRunTime.boxToInteger((int)apiPR.getNumber())).flatMap((Function1 & Serializable)number -> PullRequestLister.$anonfun$parsePullRequest$1(this, apiPR, parsedRepository, BoxesRunTime.unboxToInt((Object)number)));
    }

    private Either<Exception, Commit> parseCommit(GHCommitPointer apiCommit) {
        return this.requireNonNull(apiCommit.getSha()).flatMap((Function1 & Serializable)x$12 -> au.id.tmm.digest4s.binarycodecs.syntax.package$.MODULE$.toTmmUtilsCodecStringOps(x$12).parseHex()).flatMap((Function1 & Serializable)sha -> {
            Option ref = Option$.MODULE$.apply((Object)apiCommit.getRef());
            Option repository2 = Option$.MODULE$.apply((Object)apiCommit.getRepository());
            return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)repository2, UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable)repository -> this.parseRepository((GHRepository)repository), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)repository -> new Commit((Option<Repository>)repository, (Option<String>)ref, (ArraySeq<Object>)sha));
        });
    }

    private Either<Exception, Repository> parseRepository(GHRepository repository) {
        return this.requireNonNull(repository.getName()).flatMap((Function1 & Serializable)repoName -> this.requireNonNull(repository.getOwnerName()).flatMap((Function1 & Serializable)repoOwnerName -> this.requireNonNull(repository.getHttpTransportUrl()).flatMap((Function1 & Serializable)x$14 -> JvmStringOps$.MODULE$.parseURI$extension(package.string$.MODULE$.stringJvmSyntaxMouse(x$14))).flatMap((Function1 & Serializable)httpsCloneUri -> this.requireNonNull(repository.getSshUrl()).map((Function1 & Serializable)sshCloneUri -> new Repository(new Repository.CloneUris((String)sshCloneUri, (URI)httpsCloneUri), new RepositoryName((String)repoOwnerName, (String)repoName))))));
    }

    private <A> Either<Exception, A> requireNonNull(A a) {
        return a == null ? package$.MODULE$.Left().apply((Object)GenericException$.MODULE$.apply("Encountered null")) : package$.MODULE$.Right().apply(a);
    }

    public static final /* synthetic */ Either $anonfun$parsePullRequest$8(PullRequestLister $this, GHPullRequest apiPR$1, Repository parsedRepository$2, int number$1, Instant whenCreated$1, Option whenClosed$1, String title$1, URI htmlUrl$1, boolean isOpen) {
        return $this.requireNonNull(apiPR$1.getPatchUrl()).map((Function1 & Serializable)x$6 -> x$6.toURI()).flatMap((Function1 & Serializable)patch -> $this.requireNonNull(apiPR$1.getDiffUrl()).map((Function1 & Serializable)x$7 -> x$7.toURI()).flatMap((Function1 & Serializable)diff -> $this.requireNonNull(apiPR$1.getIssueUrl()).map((Function1 & Serializable)x$8 -> x$8.toURI()).flatMap((Function1 & Serializable)issue -> $this.requireNonNull(apiPR$1.getBase()).flatMap((Function1 & Serializable)apiCommit -> $this.parseCommit((GHCommitPointer)apiCommit)).flatMap((Function1 & Serializable)base -> $this.requireNonNull(apiPR$1.getHead()).flatMap((Function1 & Serializable)apiCommit -> $this.parseCommit((GHCommitPointer)apiCommit)).map((Function1 & Serializable)head -> {
            Option whenMerged = Option$.MODULE$.apply((Object)apiPR$1.getMergedAt()).map((Function1 & Serializable)x$9 -> x$9.toInstant());
            return new PullRequest(parsedRepository$2, number$1, whenCreated$1, (Option<Instant>)whenClosed$1, title$1, htmlUrl$1, isOpen, (URI)patch, (URI)diff, (URI)issue, (Commit)base, (Commit)head, (Option<Instant>)whenMerged);
        })))));
    }

    public static final /* synthetic */ Either $anonfun$parsePullRequest$1(PullRequestLister $this, GHPullRequest apiPR$1, Repository parsedRepository$2, int number) {
        return $this.requireNonNull(apiPR$1.getCreatedAt()).map((Function1 & Serializable)x$3 -> x$3.toInstant()).flatMap((Function1 & Serializable)whenCreated -> {
            Option whenClosed = Option$.MODULE$.apply((Object)apiPR$1.getClosedAt()).map((Function1 & Serializable)x$4 -> x$4.toInstant());
            return $this.requireNonNull(apiPR$1.getTitle()).flatMap((Function1 & Serializable)title -> $this.requireNonNull(apiPR$1.getHtmlUrl()).map((Function1 & Serializable)x$5 -> x$5.toURI()).flatMap((Function1 & Serializable)htmlUrl -> {
                GHIssueState gHIssueState = apiPR$1.getState();
                GHIssueState gHIssueState2 = GHIssueState.OPEN;
                return $this.requireNonNull(BoxesRunTime.boxToBoolean((!(gHIssueState != null ? !gHIssueState.equals(gHIssueState2) : gHIssueState2 != null) ? 1 : 0) != 0)).flatMap((Function1 & Serializable)isOpen -> PullRequestLister.$anonfun$parsePullRequest$8($this, apiPR$1, parsedRepository$2, number, whenCreated, whenClosed, title, htmlUrl, BoxesRunTime.unboxToBoolean((Object)isOpen)));
            }));
        });
    }

    public PullRequestLister(GitHubConfiguration gitHubConfiguration) {
        this.gitHubConfiguration = gitHubConfiguration;
    }
}

