/*
 * Decompiled with CFR 0.152.
 */
package au.id.tmm.githubprlanguagedetection.reporting;

import au.id.tmm.collections.NonEmptyArraySeq;
import au.id.tmm.collections.NonEmptyArraySeq$;
import au.id.tmm.digest4s.digest.SHA256Digest;
import au.id.tmm.githubprlanguagedetection.common.DirectoryDigester;
import au.id.tmm.githubprlanguagedetection.git.BranchCloner;
import au.id.tmm.githubprlanguagedetection.github.PullRequestLister;
import au.id.tmm.githubprlanguagedetection.github.model.PullRequest;
import au.id.tmm.githubprlanguagedetection.github.model.RepositoryName;
import au.id.tmm.githubprlanguagedetection.languagedetection.LanguageDetector;
import au.id.tmm.githubprlanguagedetection.languagedetection.model.DetectedLanguages;
import au.id.tmm.githubprlanguagedetection.reporting.ReportWriter$;
import au.id.tmm.githubprlanguagedetection.reporting.model.GitHubPrLanguageDetectionReport;
import au.id.tmm.intime.std.syntax.package;
import au.id.tmm.utilities.errors.GenericException$;
import cats.NonEmptyParallel;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import fs2.Collector$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!\u0001\u0005A!A!\u0002\u0017\t\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b1B'\t\u0011A\u0003!\u0011!Q\u0001\fECQ\u0001\u0016\u0001\u0005\u0002UCQ\u0001\u0019\u0001\u0005\u0002\u0005DQa\u001e\u0001\u0005\naDq!a\u0010\u0001\t\u0013\t\teB\u0004\u0002FJA\t!a2\u0007\rE\u0011\u0002\u0012AAe\u0011\u0019!V\u0002\"\u0001\u0002L\"I\u0011QZ\u0007C\u0002\u0013%\u0011q\u001a\u0005\t\u0003Cl\u0001\u0015!\u0003\u0002R\na!+\u001a9peR<&/\u001b;fe*\u00111\u0003F\u0001\ne\u0016\u0004xN\u001d;j]\u001eT!!\u0006\f\u00023\u001dLG\u000f[;caJd\u0017M\\4vC\u001e,G-\u001a;fGRLwN\u001c\u0006\u0003/a\t1\u0001^7n\u0015\tI\"$\u0001\u0002jI*\t1$\u0001\u0002bk\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u0006\t\u0002/\u001e7m%\u0016\fX/Z:u\u0019&\u001cH/\u001a:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\"\u0012AB4ji\",(-\u0003\u0002+O\t\t\u0002+\u001e7m%\u0016\fX/Z:u\u0019&\u001cH/\u001a:\u0002\u0019\t\u0014\u0018M\\2i\u00072|g.\u001a:\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0012aA4ji&\u0011\u0011G\f\u0002\r\u0005J\fgn\u00195DY>tWM]\u0001\u0011Y\u0006tw-^1hK\u0012+G/Z2u_J\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u000b\u0002#1\fgnZ;bO\u0016$W\r^3di&|g.\u0003\u00029k\t\u0001B*\u00198hk\u0006<W\rR3uK\u000e$xN]\u0001\u0012I&\u0014Xm\u0019;pef$\u0015nZ3ti\u0016\u0014\bCA\u001e?\u001b\u0005a$BA\u001f\u0015\u0003\u0019\u0019w.\\7p]&\u0011q\b\u0010\u0002\u0012\t&\u0014Xm\u0019;pef$\u0015nZ3ti\u0016\u0014\u0018!\u0002;j[\u0016\u0014\bc\u0001\"H\u00136\t1I\u0003\u0002E\u000b\u00061QM\u001a4fGRT\u0011AR\u0001\u0005G\u0006$8/\u0003\u0002I\u0007\n)A+[7feB\u0011!IS\u0005\u0003\u0017\u000e\u0013!!S(\u0002\u0019\r|g\u000e^3yiNC\u0017N\u001a;\u0011\u0007\ts\u0015*\u0003\u0002P\u0007\na1i\u001c8uKb$8\u000b[5gi\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u0011\u0007\t\u0013\u0016*\u0003\u0002T\u0007\nQ1i\u001c8dkJ\u0014XM\u001c;\u0002\rqJg.\u001b;?)\u00151F,\u00180`)\u00119\u0016LW.\u0011\u0005a\u0003Q\"\u0001\n\t\u000b\u0001C\u00019A!\t\u000b1C\u00019A'\t\u000bAC\u00019A)\t\u000b\u0011B\u0001\u0019A\u0013\t\u000b-B\u0001\u0019\u0001\u0017\t\u000bIB\u0001\u0019A\u001a\t\u000beB\u0001\u0019\u0001\u001e\u0002MA\u0014x\u000eZ;dK\u001eKG\u000fS;c!Jd\u0015M\\4vC\u001e,G)\u001a;fGRLwN\u001c*fa>\u0014H\u000f\u0006\u0003cS:\u0004\bc\u0001\"KGB\u0011AmZ\u0007\u0002K*\u0011aME\u0001\u0006[>$W\r\\\u0005\u0003Q\u0016\u0014qdR5u\u0011V\u0014\u0007K\u001d'b]\u001e,\u0018mZ3EKR,7\r^5p]J+\u0007o\u001c:u\u0011\u0015Q\u0017\u00021\u0001l\u0003I\u0019\u0007.Z2l_V$8\u000fU3s\u001b&tW\u000f^3\u0011\u0005}a\u0017BA7!\u0005\rIe\u000e\u001e\u0005\u0006_&\u0001\ra[\u0001\u000e[\u0006D8i\u001c8dkJ\u0014XM\u001c;\t\u000bEL\u0001\u0019\u0001:\u0002\u0015I,\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002tk6\tAO\u0003\u0002gO%\u0011a\u000f\u001e\u0002\u000f%\u0016\u0004xn]5u_JLh*Y7f\u0003Q\u0019HO]3b[RC\u0017\r^#nSR\u001cXI^3ssV\u0019\u00110!\u0002\u0015\u000bi\f9\"a\u000b\u0011\u000bmt\u0018*!\u0001\u000e\u0003qT\u0011!`\u0001\u0004MN\u0014\u0014BA@}\u0005\u0019\u0019FO]3b[B!\u00111AA\u0003\u0019\u0001!q!a\u0002\u000b\u0005\u0004\tIAA\u0001B#\u0011\tY!!\u0005\u0011\u0007}\ti!C\u0002\u0002\u0010\u0001\u0012qAT8uQ&tw\rE\u0002 \u0003'I1!!\u0006!\u0005\r\te.\u001f\u0005\b\u00033Q\u0001\u0019AA\u000e\u0003!)G.Z7f]R\u001c\bCBA\u000f\u0003O\t\t!\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003%IW.\\;uC\ndWMC\u0002\u0002&\u0001\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0011\u0005\u0013(/Y=TKFDq!!\f\u000b\u0001\u0004\ty#A\u0003eK2\f\u0017\u0010\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\tQLW.\u001a\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u001a\u0005!!UO]1uS>t\u0017AD7bW\u0016Le\u000e^8SKB|'\u000f\u001e\u000b\u0004G\u0006\r\u0003bBA#\u0017\u0001\u0007\u0011qI\u0001\re\u0016\u001cX\u000f\u001c;t!\u0016\u0014\bK\u001d\t\u0007\u0003\u0013\ny%a\u0015\u000e\u0005\u0005-#bAA'-\u0005Y1m\u001c7mK\u000e$\u0018n\u001c8t\u0013\u0011\t\t&a\u0013\u0003!9{g.R7qif\f%O]1z'\u0016\f\b\u0003CA+\u0003\u000b\u000bY)!%\u000f\t\u0005]\u0013q\u0010\b\u0005\u00033\nIH\u0004\u0003\u0002\\\u0005Md\u0002BA/\u0003_rA!a\u0018\u0002n9!\u0011\u0011MA6\u001d\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA49\u00051AH]8pizJ\u0011aG\u0005\u00033iI!a\u0006\r\n\u0007\u0005Ed#A\u0005vi&d\u0017\u000e^5fg&!\u0011QOA<\u0003\u0019\u0019\u0018P\u001c;bq*\u0019\u0011\u0011\u000f\f\n\t\u0005m\u0014QP\u0001\u0007iV\u0004H.Z:\u000b\t\u0005U\u0014qO\u0005\u0005\u0003\u0003\u000b\u0019)A\u0004qC\u000e\\\u0017mZ3\u000b\t\u0005m\u0014QP\u0005\u0005\u0003\u000f\u000bII\u0001\b%[&tWo\u001d\u0013he\u0016\fG/\u001a:\u000b\t\u0005\u0005\u00151\u0011\t\u0004g\u00065\u0015bAAHi\nY\u0001+\u001e7m%\u0016\fX/Z:u!\u0019\t\u0019*a(\u0002&:!\u0011QSAN\u001d\u0011\tY&a&\n\t\u0005e\u0015qO\u0001\u0007KJ\u0014xN]:\n\t\u0005\u0005\u0015Q\u0014\u0006\u0005\u00033\u000b9(\u0003\u0003\u0002\"\u0006\r&aC#yG\u0016\u0004H/[8o\u001fJTA!!!\u0002\u001eB9q$a*\u0002,\u0006m\u0016bAAUA\t1A+\u001e9mKJ\u0002B!!,\u000286\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0004eS\u001e,7\u000f\u001e\u0006\u0004\u0003k3\u0012\u0001\u00033jO\u0016\u001cH\u000fN:\n\t\u0005e\u0016q\u0016\u0002\r'\"\u000b%'\u000e\u001cES\u001e,7\u000f\u001e\t\u0005\u0003{\u000b\t-\u0004\u0002\u0002@*\u0011a-N\u0005\u0005\u0003\u0007\fyLA\tEKR,7\r^3e\u0019\u0006tw-^1hKN\fABU3q_J$xK]5uKJ\u0004\"\u0001W\u0007\u0014\u00055qBCAAd\u0003\u0019aujR$F%V\u0011\u0011\u0011\u001b\t\u0005\u0003'\fi.\u0004\u0002\u0002V*!\u0011q[Am\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\tY.A\u0002pe\u001eLA!a8\u0002V\n1Aj\\4hKJ\fq\u0001T(H\u000f\u0016\u0013\u0006\u0005")
public class ReportWriter {
    private final PullRequestLister pullRequestLister;
    private final BranchCloner branchCloner;
    private final LanguageDetector languageDetector;
    private final DirectoryDigester directoryDigester;
    private final Timer<IO> timer;
    private final ContextShift<IO> contextShift;
    private final Concurrent<IO> concurrent;

    public IO<GitHubPrLanguageDetectionReport> produceGitHubPrLanguageDetectionReport(int checkoutsPerMinute, int maxConcurrent, RepositoryName repository) {
        return this.pullRequestLister.listPullRequestsFor(repository).flatMap((Function1 & Serializable)pullRequests -> {
            Duration delayBetweenCheckouts = package.all$.MODULE$.toDurationOps(Duration.ofMinutes(1L)).$div((long)checkoutsPerMinute);
            return ((IO)Stream$.MODULE$.compile$extension(Stream$.MODULE$.parEvalMap$extension(this.streamThatEmitsEvery((ArraySeq)pullRequests, delayBetweenCheckouts), maxConcurrent, (Function1 & Serializable)pullRequest -> {
                IO resultIO = IO$.MODULE$.pure((Object)pullRequest.repository().cloneUris().https()).flatMap((Function1 & Serializable)cloneUri -> {
                    BranchCloner.Reference.GitHubPullRequestHead refToClone = new BranchCloner.Reference.GitHubPullRequestHead(pullRequest.number());
                    return $this.branchCloner.useRepositoryAtRef((URI)cloneUri, refToClone, (Function2 & Serializable)(repositoryPath, jGit) -> $this.directoryDigester.digestFor((Path)repositoryPath).parProduct($this.languageDetector.detectLanguages((Path)repositoryPath), (NonEmptyParallel)IO$.MODULE$.ioParallel($this.contextShift))).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        ArraySeq.ofByte checksum = ((SHA256Digest)tuple2._1()).asBytes();
                        DetectedLanguages detectedLanguages = (DetectedLanguages)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)new SHA256Digest(checksum), (Object)detectedLanguages);
                        return tuple22;
                    });
                });
                return resultIO.attempt().flatMap((Function1 & Serializable)x0$1 -> {
                    Throwable t;
                    boolean bl = false;
                    Left left = null;
                    Either either = x0$1;
                    if (either instanceof Left) {
                        bl = true;
                        left = (Left)either;
                        Throwable e = (Throwable)left.value();
                        if (e instanceof Exception) {
                            Exception exception = (Exception)e;
                            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ReportWriter$.MODULE$.au$id$tmm$githubprlanguagedetection$reporting$ReportWriter$$LOGGER().error(new StringBuilder(31).append("Failed to parse languages for #").append(pullRequest.number()).toString(), (Throwable)exception)).as((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pullRequest), (Object)package$.MODULE$.Left().apply((Object)exception)));
                        }
                    }
                    if (bl && (t = (Throwable)left.value()) != null) {
                        Throwable throwable = t;
                        return IO$.MODULE$.raiseError(throwable);
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Right right = (Right)either;
                    Tuple2 result = (Tuple2)right.value();
                    return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ReportWriter$.MODULE$.au$id$tmm$githubprlanguagedetection$reporting$ReportWriter$$LOGGER().info(new StringBuilder(42).append("Parsed languages for #").append(pullRequest.number()).append(". Main language was ").append(((DetectedLanguages)result._2()).mainProgrammingLanguage().name()).toString())).as((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pullRequest), (Object)package$.MODULE$.Right().apply((Object)result)));
                });
            }, $this.concurrent), Stream.Compiler$.MODULE$.syncInstance($this.concurrent)).to(Collector$.MODULE$.supportsTaggedArraySeq(ArraySeq$.MODULE$, ClassTag$.MODULE$.apply(Tuple2.class)))).flatMap((Function1 & Serializable)detectedLanguagesPerPullRequest -> IO$.MODULE$.fromEither(NonEmptyArraySeq$.MODULE$.fromArraySeq(detectedLanguagesPerPullRequest).toRight((Function0 & Serializable)() -> GenericException$.MODULE$.apply("No prs"))).map((Function1 & Serializable)nonEmptyDetectedLanguagesPerPullRequest -> {
                void var2_2;
                GitHubPrLanguageDetectionReport report = this.makeIntoReport((NonEmptyArraySeq<Tuple2<PullRequest, Either<Exception, Tuple2<SHA256Digest, DetectedLanguages>>>>)nonEmptyDetectedLanguagesPerPullRequest);
                return var2_2;
            }));
        });
    }

    private <A> FreeC<IO, A, BoxedUnit> streamThatEmitsEvery(ArraySeq<A> elements, Duration delay) {
        return Stream$.MODULE$.zipRight$extension(Stream$.MODULE$.fixedDelay(Duration$.MODULE$.apply(delay.toMillis(), TimeUnit.MILLISECONDS), this.timer), Stream$.MODULE$.emits(elements));
    }

    private GitHubPrLanguageDetectionReport makeIntoReport(NonEmptyArraySeq<Tuple2<PullRequest, Either<Exception, Tuple2<SHA256Digest, DetectedLanguages>>>> resultsPerPr) {
        return new GitHubPrLanguageDetectionReport((NonEmptyArraySeq<Tuple2<PullRequest, GitHubPrLanguageDetectionReport.PullRequestResult>>)((NonEmptyArraySeq)resultsPerPr.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Right right;
                Tuple2 tuple22;
                PullRequest pr = (PullRequest)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Right && (tuple22 = (Tuple2)(right = (Right)either).value()) != null) {
                    ArraySeq.ofByte checksum = ((SHA256Digest)tuple22._1()).asBytes();
                    DetectedLanguages detectedLanguages = (DetectedLanguages)tuple22._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pr), (Object)new GitHubPrLanguageDetectionReport.PullRequestResult.Success(detectedLanguages, checksum));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            PullRequest pr = (PullRequest)tuple2._1();
            Either either = (Either)tuple2._2();
            if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
            Left left = (Left)either;
            Exception e = (Exception)left.value();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pr), (Object)new GitHubPrLanguageDetectionReport.PullRequestResult.Failure(e));
        })));
    }

    public ReportWriter(PullRequestLister pullRequestLister, BranchCloner branchCloner, LanguageDetector languageDetector, DirectoryDigester directoryDigester, Timer<IO> timer, ContextShift<IO> contextShift, Concurrent<IO> concurrent) {
        this.pullRequestLister = pullRequestLister;
        this.branchCloner = branchCloner;
        this.languageDetector = languageDetector;
        this.directoryDigester = directoryDigester;
        this.timer = timer;
        this.contextShift = contextShift;
        this.concurrent = concurrent;
    }
}

