/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.io.Serializable;

public class ResourceDirective
implements Serializable {
    private final String m_group;
    private final String m_name;
    private final String m_version;
    private final String m_type;

    public ResourceDirective(String group, String name, String version) {
        this(group, name, version, "jar");
    }

    public ResourceDirective(String group, String name, String version, String type) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.m_group = group;
        this.m_name = name;
        this.m_version = version;
        this.m_type = type;
    }

    public String getId() {
        return this.m_group + ":" + this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getType() {
        return this.m_type;
    }

    public static ResourceDirective createResourceDirective(String id, String version) {
        return ResourceDirective.createResourceDirective(id, version, "jar");
    }

    public static ResourceDirective createResourceDirective(String id, String version, String type) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        String group = null;
        String name = null;
        int n = id.indexOf(":");
        if (id.indexOf(":") > 0) {
            group = id.substring(0, n);
            name = id.substring(n + 1, id.length());
        } else {
            group = id;
            name = id;
        }
        return new ResourceDirective(group, name, version, type);
    }
}

