/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.Profile;
import org.apache.avalon.composition.data.StageDirective;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;

public class DeploymentProfile
extends Profile {
    private CategoriesDirective m_categories;
    private String m_classname;
    private Parameters m_parameters;
    private Configuration m_configuration;
    private ContextDirective m_context;
    private DependencyDirective[] m_dependencies;
    private StageDirective[] m_stages;
    private Mode m_mode;

    public DeploymentProfile(String name, String classname) {
        this(name, false, classname, null, null, null, null, null, null, Mode.IMPLICIT);
    }

    public DeploymentProfile(String name, DeploymentProfile template) {
        this(name, template.getActivationPolicy(), template.m_classname, template.m_categories, template.m_context, template.m_dependencies, template.m_stages, template.m_parameters, template.m_configuration, Mode.EXPLICIT);
    }

    public DeploymentProfile(String name, boolean activation, String classname, CategoriesDirective categories, ContextDirective context, DependencyDirective[] dependencies, StageDirective[] stages, Parameters parameters, Configuration config, Mode mode) {
        super(name, activation, mode);
        this.m_classname = classname;
        this.m_categories = categories;
        this.m_context = context;
        this.m_parameters = parameters;
        this.m_configuration = config;
        this.m_dependencies = dependencies == null ? new DependencyDirective[0] : dependencies;
        this.m_stages = stages == null ? new StageDirective[0] : stages;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public CategoriesDirective getCategories() {
        return this.m_categories;
    }

    public ContextDirective getContext() {
        return this.m_context;
    }

    public DependencyDirective[] getDependencyDirectives() {
        return this.m_dependencies;
    }

    public DependencyDirective getDependencyDirective(String key) {
        DependencyDirective[] directives = this.getDependencyDirectives();
        for (int i = 0; i < directives.length; ++i) {
            DependencyDirective directive = directives[i];
            if (!directive.getKey().equals(key)) continue;
            return directive;
        }
        return null;
    }

    public StageDirective[] getStageDirectives() {
        return this.m_stages;
    }

    public StageDirective getStageDirective(String key) {
        StageDirective[] directives = this.getStageDirectives();
        for (int i = 0; i < directives.length; ++i) {
            StageDirective directive = directives[i];
            if (!directive.getKey().equals(key)) continue;
            return directive;
        }
        return null;
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

