/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelRuntimeException;

public class DependencyGraph {
    private final DependencyGraph m_parent;
    private final ArrayList m_models = new ArrayList();
    private final ArrayList m_children = new ArrayList();

    public DependencyGraph() {
        this(null);
    }

    public DependencyGraph(DependencyGraph parent) {
        this.m_parent = parent;
    }

    public void addChild(DependencyGraph child) {
        this.m_children.add(child);
    }

    public void removeChild(DependencyGraph child) {
        ((AbstractCollection)this.m_children).remove(child);
    }

    public void add(DeploymentModel model) {
        if (!this.m_models.contains(model)) {
            this.m_models.add(model);
        }
    }

    public void remove(DeploymentModel model) {
        ((AbstractCollection)this.m_models).remove(model);
    }

    public DeploymentModel[] getStartupGraph() {
        try {
            return this.walkGraph(true);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving startup graph.";
            throw new ModelRuntimeException("Unexpect error while resolving startup graph.", e);
        }
    }

    public DeploymentModel[] getShutdownGraph() {
        try {
            return this.walkGraph(false);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving shutdown graph.";
            throw new ModelRuntimeException("Unexpect error while resolving shutdown graph.", e);
        }
    }

    public DeploymentModel[] getConsumerGraph(DeploymentModel model) {
        if (this.m_parent != null) {
            return this.m_parent.getConsumerGraph(model);
        }
        try {
            DeploymentModel[] graph = this.getComponentGraph(model, false);
            return this.referencedModels(model, graph);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving consumer graph for model: " + model;
            throw new ModelRuntimeException(error, e);
        }
    }

    public DeploymentModel[] getProviderGraph(DeploymentModel model) {
        try {
            return this.referencedModels(model, this.getComponentGraph(model, true));
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving provider graph for: " + model;
            throw new ModelRuntimeException(error, e);
        }
    }

    private DeploymentModel[] referencedModels(DeploymentModel model, DeploymentModel[] models) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        for (int i = 0; i < models.length; ++i) {
            if (models[i].equals(model)) continue;
            list.add(models[i]);
        }
        return list.toArray(new DeploymentModel[0]);
    }

    private DeploymentModel[] getComponentGraph(DeploymentModel model, boolean providers) {
        ArrayList result = new ArrayList();
        this.visitcomponent(model, providers, new ArrayList(), result);
        DeploymentModel[] returnValue = new DeploymentModel[result.size()];
        return result.toArray(returnValue);
    }

    private DeploymentModel[] walkGraph(boolean direction) {
        ArrayList result = new ArrayList();
        ArrayList done = new ArrayList();
        int size = this.m_models.size();
        for (int i = 0; i < size; ++i) {
            DeploymentModel model = (DeploymentModel)this.m_models.get(i);
            this.visitcomponent(model, direction, done, result);
        }
        DeploymentModel[] returnValue = new DeploymentModel[result.size()];
        return result.toArray(returnValue);
    }

    private void visitcomponent(DeploymentModel model, boolean direction, ArrayList done, ArrayList order) {
        if (done.contains(model)) {
            return;
        }
        done.add(model);
        if (direction) {
            this.visitProviders(model, done, order);
        } else {
            this.visitConsumers(model, done, order);
        }
        order.add(model);
    }

    private void visitProviders(DeploymentModel model, ArrayList done, ArrayList order) {
        DeploymentModel[] providers = model.getProviders();
        for (int i = providers.length - 1; i > -1; --i) {
            this.visitcomponent(providers[i], true, done, order);
        }
    }

    private void visitConsumers(DeploymentModel model, ArrayList done, ArrayList order) {
        int size = this.m_models.size();
        for (int i = 0; i < size; ++i) {
            DeploymentModel other = (DeploymentModel)this.m_models.get(i);
            DeploymentModel[] providers = other.getProviders();
            for (int j = 0; j < providers.length; ++j) {
                DeploymentModel provider = providers[j];
                if (!provider.equals(model)) continue;
                this.visitcomponent(other, false, done, order);
            }
        }
        int childCount = this.m_children.size();
        for (int i = 0; i < childCount; ++i) {
            DependencyGraph map = (DependencyGraph)this.m_children.get(i);
            map.visitConsumers(model, done, order);
        }
    }
}

