/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.avalon.composition.data.BlockCompositionDirective;
import org.apache.avalon.composition.data.BlockIncludeDirective;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ClasspathDirective;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.FilesetDirective;
import org.apache.avalon.composition.data.IncludeDirective;
import org.apache.avalon.composition.data.LibraryDirective;
import org.apache.avalon.composition.data.Profile;
import org.apache.avalon.composition.data.RepositoryDirective;
import org.apache.avalon.composition.data.ResourceDirective;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.composition.data.writer.XMLDeploymentProfileWriter;

public class XMLContainmentProfileWriter
extends XMLDeploymentProfileWriter {
    public void writeContainmentProfile(ContainmentProfile profile, OutputStream output) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.writeHeader(writer, profile);
        this.writeContainmentProfile(writer, profile, true, "");
        ((Writer)writer).flush();
    }

    protected void writeContainmentProfile(Writer writer, ContainmentProfile profile, String pad) throws Exception {
        this.writeContainmentProfile(writer, profile, false, pad);
    }

    protected void writeContainmentProfile(Writer writer, ContainmentProfile profile, boolean flag, String pad) throws Exception {
        writer.write("\n");
        writer.write(pad + "<container name=\"" + profile.getName() + "\">");
        String padding = pad + "  ";
        this.writeServiceDirectives(writer, profile.getExportDirectives(), padding);
        this.writeClassLoader(writer, profile.getClassLoaderDirective(), padding);
        this.writeCategories(writer, profile.getCategories(), padding);
        this.writeProfiles(writer, profile.getProfiles(), padding);
        writer.write("\n" + pad + "</container>");
        writer.write("\n");
    }

    private void writeHeader(Writer writer, ContainmentProfile profile) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
    }

    private void writeServiceDirectives(Writer writer, ServiceDirective[] services, String pad) throws IOException {
        if (0 == services.length) {
            return;
        }
        writer.write("\n" + pad + "<services>");
        String padding = pad + "  ";
        for (int i = 0; i < services.length; ++i) {
            ServiceDirective service = services[i];
            writer.write("\n" + padding + "<service type=\"");
            writer.write(service.getReference().getClassname());
            if (service.getReference().getVersion().getMajor() > -1) {
                writer.write("\" version=\"" + service.getReference().getVersion());
            }
            writer.write("\">");
            writer.write("\n" + padding + "  " + "<source>" + service.getPath() + "</source>");
            writer.write("\n" + padding + "</service>");
        }
        writer.write("\n" + pad + "</services>");
    }

    private void writeClassLoader(Writer writer, ClassLoaderDirective classloader, String pad) throws IOException {
        if (classloader.isEmpty()) {
            return;
        }
        writer.write("\n" + pad + "<classloader>");
        String padding = pad + "  ";
        LibraryDirective library = classloader.getLibrary();
        this.writeLibrary(writer, library, padding);
        ClasspathDirective classpath = classloader.getClasspathDirective();
        this.writeClasspathDirective(writer, classpath, padding);
        writer.write("\n" + pad + "</classloader>");
    }

    private void writeLibrary(Writer writer, LibraryDirective library, String pad) throws IOException {
        if (library.isEmpty()) {
            return;
        }
        String padding = pad + "  ";
        writer.write("\n" + pad + "<library>");
        String[] includes = library.getIncludes();
        for (int i = 0; i < includes.length; ++i) {
            writer.write("\n" + padding + "<include>" + includes[i] + "</include>");
        }
        String[] groups = library.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            writer.write("\n" + padding + "<group>" + groups[i] + "</group>");
        }
        writer.write("\n" + pad + "</library>");
    }

    private void writeClasspathDirective(Writer writer, ClasspathDirective classpath, String pad) throws IOException {
        RepositoryDirective[] repositories;
        if (classpath.isEmpty()) {
            return;
        }
        String padding = pad + "  ";
        writer.write("\n" + pad + "<classpath>");
        FilesetDirective[] filesets = classpath.getFilesets();
        if (filesets.length > 0) {
            for (int i = 0; i < filesets.length; ++i) {
                this.writeFilesetDirective(writer, filesets[i], padding);
            }
        }
        if ((repositories = classpath.getRepositoryDirectives()).length > 0) {
            for (int i = 0; i < repositories.length; ++i) {
                this.writeRepositoryDirective(writer, repositories[i], padding);
            }
        }
        writer.write("\n" + pad + "</classpath>");
    }

    private void writeRepositoryDirective(Writer writer, RepositoryDirective repository, String pad) throws IOException {
        ResourceDirective[] resources = repository.getResources();
        if (resources.length > 0) {
            String padding = pad + "  ";
            writer.write("\n" + pad + "<repository>");
            for (int i = 0; i < resources.length; ++i) {
                this.writeResourceDirective(writer, resources[i], padding);
            }
            writer.write("\n" + pad + "</repository>");
        }
    }

    private void writeFilesetDirective(Writer writer, FilesetDirective fileset, String pad) throws IOException {
        writer.write("\n" + pad + "<fileset dir=\"" + fileset.getBaseDirectory() + "\">");
        IncludeDirective[] includes = fileset.getIncludes();
        for (int i = 0; i < includes.length; ++i) {
            writer.write("\n" + pad + "  " + "<include>" + includes[i].getPath() + "</include>");
        }
        writer.write("\n" + pad + "</fileset>");
    }

    private void writeResourceDirective(Writer writer, ResourceDirective resource, String pad) throws IOException {
        writer.write("\n" + pad + "<resource");
        writer.write(" id=\"" + resource.getId() + "\"");
        if (resource.getVersion() != null) {
            writer.write(" version=\"" + resource.getVersion() + "\"");
            if (!resource.getType().equals("jar")) {
                writer.write(" type=\"" + resource.getType() + "\"");
            }
        }
        writer.write("/>");
    }

    private void writeProfiles(Writer writer, Profile[] profiles, String pad) throws Exception {
        for (int i = 0; i < profiles.length; ++i) {
            BlockIncludeDirective directive;
            Profile profile = profiles[i];
            if (profile instanceof ContainmentProfile) {
                ContainmentProfile container = (ContainmentProfile)profile;
                writer.write("\n");
                this.writeContainmentProfile(writer, container, pad);
                continue;
            }
            if (profile instanceof DeploymentProfile) {
                DeploymentProfile component = (DeploymentProfile)profile;
                writer.write("\n");
                this.writeDeploymentProfile(writer, component, pad);
                continue;
            }
            if (profile instanceof BlockIncludeDirective) {
                directive = (BlockIncludeDirective)profile;
                writer.write("\n");
                this.writeBlockIncludeDirective(writer, directive, pad);
                continue;
            }
            if (profile instanceof BlockCompositionDirective) {
                directive = (BlockCompositionDirective)profile;
                writer.write("\n");
                this.writeBlockCompositionDirective(writer, (BlockCompositionDirective)directive, pad);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized profile class: " + profile.getClass().getName());
        }
    }

    private void writeBlockIncludeDirective(Writer writer, BlockIncludeDirective directive, String pad) throws Exception {
        writer.write("\n" + pad + "<include name=\"");
        writer.write(directive.getName() + "\">");
        writer.write("\n" + pad + "  " + "<source>");
        writer.write(directive.getPath() + "</source>");
        writer.write("\n" + pad + "</include>");
    }

    private void writeBlockCompositionDirective(Writer writer, BlockCompositionDirective directive, String pad) throws Exception {
        writer.write("\n" + pad + "<include name=\"");
        writer.write(directive.getName() + "\" id=\"");
        writer.write(directive.getResource().getId() + "\" version=\"");
        writer.write(directive.getResource().getVersion() + "\"/>");
    }
}

