/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.log4j;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.logging.impl.DefaultLoggingCriteria;
import org.apache.avalon.logging.log4j.LoggingManagerImpl;
import org.apache.avalon.logging.provider.LoggingCriteria;
import org.apache.avalon.logging.provider.LoggingException;
import org.apache.avalon.logging.provider.LoggingFactory;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JLoggingFactory
implements LoggingFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$log4j$Log4JLoggingFactory == null ? (class$org$apache$avalon$logging$log4j$Log4JLoggingFactory = Log4JLoggingFactory.class$("org.apache.avalon.logging.log4j.Log4JLoggingFactory")) : class$org$apache$avalon$logging$log4j$Log4JLoggingFactory));
    private final ClassLoader m_Classloader;
    private final InitialContext m_Context;
    private File m_BaseDirectory;
    static /* synthetic */ Class class$org$apache$avalon$logging$log4j$Log4JLoggingFactory;

    public Log4JLoggingFactory(InitialContext context, ClassLoader classloader) {
        this.m_Context = context;
        this.m_Classloader = classloader;
    }

    public LoggingCriteria createDefaultLoggingCriteria() {
        return new DefaultLoggingCriteria(this.m_Context);
    }

    public LoggingManager createLoggingManager(LoggingCriteria criteria) throws LoggingException {
        try {
            return (LoggingManager)this.create((Map)criteria);
        }
        catch (Throwable e) {
            String error = "Cannot build logging manager.";
            throw new LoggingException("Cannot build logging manager.", e);
        }
    }

    public Map createDefaultCriteria() {
        return this.createDefaultLoggingCriteria();
    }

    public Object create() throws Exception {
        return new LoggingManagerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Map criteriaMap) throws Exception {
        if (null == criteriaMap) {
            throw new NullPointerException("criteriaMap");
        }
        LoggingCriteria criteria = this.getLoggingCriteria(criteriaMap);
        this.m_BaseDirectory = criteria.getBaseDirectory();
        String cwd = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", this.m_BaseDirectory.getAbsolutePath());
            URL conf = criteria.getLoggingConfiguration();
            long updateInterval = criteria.getUpdateInterval();
            this.configure(conf, updateInterval);
            LoggingManagerImpl loggingManagerImpl = new LoggingManagerImpl();
            return loggingManagerImpl;
        }
        finally {
            System.setProperty("user.dir", cwd);
        }
    }

    private void configure(URL url, long interval) {
        String src = url.toExternalForm();
        if (src.startsWith("file:")) {
            src = src.substring(5);
            while (src.startsWith("/")) {
                src = src.substring(1);
            }
            this.configureFile(src, interval);
        }
        this.configureURL(url);
    }

    private void configureFile(String src, long interval) {
        if (interval > 0L) {
            if (src.endsWith(".xml")) {
                DOMConfigurator.configureAndWatch((String)src, (long)interval);
            } else {
                PropertyConfigurator.configureAndWatch((String)src, (long)interval);
            }
        } else if (src.endsWith(".xml")) {
            DOMConfigurator.configureAndWatch((String)src);
        } else {
            PropertyConfigurator.configureAndWatch((String)src);
        }
    }

    private void configureURL(URL url) {
        String src = url.toExternalForm();
        if (src.endsWith(".xml")) {
            DOMConfigurator.configure((URL)url);
        } else {
            PropertyConfigurator.configure((URL)url);
        }
    }

    private LoggingCriteria getLoggingCriteria(Map criteriaMap) {
        if (criteriaMap instanceof LoggingCriteria) {
            return (LoggingCriteria)criteriaMap;
        }
        String error = REZ.getString("factory.bad-criteria", (Object)criteriaMap.getClass().getName());
        throw new IllegalArgumentException(error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

