/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.io.Serializable;

public final class EntryDescriptor
implements Serializable {
    private final String m_key;
    private final String m_classname;
    private final boolean m_optional;
    private final boolean m_volatile;
    private final String m_alias;

    public EntryDescriptor(String key, String classname) throws NullPointerException {
        this(key, classname, false);
    }

    public EntryDescriptor(String key, String classname, boolean optional) throws NullPointerException {
        this(key, classname, optional, false);
    }

    public EntryDescriptor(String key, String classname, boolean optional, boolean isVolatile) throws NullPointerException {
        this(key, classname, optional, isVolatile, null);
    }

    public EntryDescriptor(String key, String classname, boolean optional, boolean isVolatile, String alias) throws NullPointerException {
        if (null == key) {
            throw new NullPointerException("key");
        }
        if (null == classname) {
            throw new NullPointerException("classnamei");
        }
        this.m_key = key;
        this.m_classname = classname;
        this.m_optional = optional;
        this.m_volatile = isVolatile;
        this.m_alias = alias;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getAlias() {
        if (this.m_alias != null) {
            return this.m_alias;
        }
        return this.m_key;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public boolean isRequired() {
        return !this.isOptional();
    }

    public boolean isVolatile() {
        return this.m_volatile;
    }

    public boolean equals(Object other) {
        boolean isEqual = other instanceof EntryDescriptor;
        if (isEqual) {
            EntryDescriptor entry = (EntryDescriptor)other;
            isEqual = isEqual && this.m_key.equals(entry.m_key);
            isEqual = isEqual && this.m_classname.equals(entry.m_classname);
            isEqual = isEqual && this.m_optional == entry.m_optional;
            boolean bl = isEqual = isEqual && this.m_volatile == entry.m_volatile;
            isEqual = null == this.m_alias ? isEqual && null == entry.m_alias : isEqual && this.m_alias.equals(entry.m_alias);
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash >>>= 13;
        hash ^= this.m_key.hashCode();
        hash >>>= 13;
        hash ^= this.m_classname.hashCode();
        hash >>>= 13;
        hash ^= null != this.m_alias ? this.m_alias.hashCode() : 0;
        hash >>>= 13;
        hash >>>= this.m_volatile ? 1 : 3;
        return hash >>>= this.m_optional ? 1 : 3;
    }
}

