/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.util.Properties;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.Descriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;

public final class DependencyDescriptor
extends Descriptor {
    private static final Version DEFAULT_VERSION = Version.getVersion((String)"1.0");
    private final int m_position;
    private final String m_key;
    private final ReferenceDescriptor m_service;
    private final boolean m_optional;

    public DependencyDescriptor(String role, String service) {
        this(role, service, DEFAULT_VERSION);
    }

    public DependencyDescriptor(String role, String service, Version version) {
        this(role, new ReferenceDescriptor(service, version), false, null);
    }

    public DependencyDescriptor(String role, ReferenceDescriptor service) {
        this(role, service, false, null);
    }

    public DependencyDescriptor(String role, ReferenceDescriptor service, boolean optional, Properties attributes) {
        this(role, service, optional, attributes, -1);
    }

    public DependencyDescriptor(String role, ReferenceDescriptor service, boolean optional, Properties attributes, int position) {
        super(attributes);
        if (null == role) {
            throw new NullPointerException("role");
        }
        if (null == service) {
            throw new NullPointerException("service");
        }
        this.m_key = role;
        this.m_service = service;
        this.m_optional = optional;
        this.m_position = position;
    }

    public String getKey() {
        return this.m_key;
    }

    public ReferenceDescriptor getService() {
        return this.m_service;
    }

    public ReferenceDescriptor getReference() {
        return this.m_service;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public boolean isRequired() {
        return !this.isOptional();
    }

    public int getPosition() {
        return this.m_position;
    }

    public String toString() {
        return "[" + this.getKey() + "] " + this.getReference();
    }

    public boolean equals(Object other) {
        boolean isEqual;
        boolean bl = isEqual = super.equals(other) && other instanceof DependencyDescriptor;
        if (other instanceof DependencyDescriptor) {
            DependencyDescriptor dep = (DependencyDescriptor)other;
            isEqual = isEqual && this.m_optional == dep.m_optional;
            isEqual = isEqual && this.m_service.equals(dep.m_service);
            isEqual = isEqual && this.m_position == dep.m_position;
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash >>>= 13;
        hash ^= this.m_service.hashCode();
        hash >>>= this.m_optional ? 1 : 0;
        return hash >>>= this.m_position;
    }
}

