/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder;

import java.io.InputStream;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.builder.SerializedTypeCreator;
import org.apache.avalon.meta.info.builder.TypeCreator;
import org.apache.avalon.meta.info.builder.TypeFactory;
import org.apache.avalon.meta.info.builder.XMLTypeCreator;
import org.xml.sax.InputSource;

public final class TypeBuilder {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$builder$TypeBuilder == null ? (class$org$apache$avalon$meta$info$builder$TypeBuilder = TypeBuilder.class$("org.apache.avalon.meta.info.builder.TypeBuilder")) : class$org$apache$avalon$meta$info$builder$TypeBuilder));
    private final TypeFactory m_xmlTypeFactory = TypeBuilder.createxmlTypeFactory();
    private final TypeCreator m_serialTypeCreator = new SerializedTypeCreator();
    static /* synthetic */ Class class$org$apache$avalon$meta$info$builder$TypeBuilder;

    public Type buildType(Class clazz) throws Exception {
        Type info = this.buildFromSerDescriptor(clazz);
        if (null != info) {
            return info;
        }
        return this.buildFromXMLDescriptor(clazz);
    }

    private Type buildFromSerDescriptor(Class clazz) throws Exception {
        Type type = this.buildFromSerDescriptor(clazz, ".ztype");
        if (type != null) {
            return type;
        }
        return this.buildFromSerDescriptor(clazz, ".zinfo");
    }

    private Type buildFromSerDescriptor(Class clazz, String form) throws Exception {
        String address;
        String classname = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(address = classname.replace('.', '/') + form);
        if (null == stream) {
            return null;
        }
        return this.m_serialTypeCreator.createType(classname, stream);
    }

    private Type buildFromXMLDescriptor(Class clazz) throws Exception {
        DefaultConfiguration defaults;
        String classname = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        TypeFactory xmlTypeFactory = this.getXMLTypeFactory();
        String path = classname.replace('.', '/') + ".xtype";
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (null == inputStream) {
            path = classname.replace('.', '/') + ".xinfo";
            inputStream = classLoader.getResourceAsStream(path);
        }
        if (null == inputStream) {
            String message = REZ.getString("builder.missing-info.error", (Object)classname);
            throw new Exception(message);
        }
        InputSource inputSource = new InputSource(inputStream);
        Configuration xinfo = ConfigurationBuilder.build(inputSource);
        String xdefaults = classname.replace('.', '/') + ".xconfig";
        InputStream defaultsStream = classLoader.getResourceAsStream(xdefaults);
        if (defaultsStream != null) {
            InputSource defaultsSource = new InputSource(defaultsStream);
            defaults = this.resolveConfiguration(classLoader, ConfigurationBuilder.build(defaultsSource));
        } else {
            defaults = new DefaultConfiguration("configuration", (String)null);
        }
        return xmlTypeFactory.createType(classname, xinfo, (Configuration)defaults);
    }

    private Configuration resolveConfiguration(ClassLoader classloader, Configuration config) throws Exception {
        if (config == null) {
            throw new NullPointerException("config");
        }
        String src = config.getAttribute("src", null);
        if (src == null) {
            return config;
        }
        if (src.startsWith("resource://")) {
            String url = src.substring(11);
            InputStream stream = classloader.getResourceAsStream(url);
            if (null == stream) {
                String error = "Requested configuration source does not exist: " + src;
                throw new ConfigurationException(error);
            }
            InputSource source = new InputSource(stream);
            return this.resolveConfiguration(classloader, ConfigurationBuilder.build(source));
        }
        try {
            return this.resolveConfiguration(classloader, ConfigurationBuilder.build(src));
        }
        catch (Throwable e) {
            String error = "Unexpected exception while attempting to resolve configuration from src : " + src;
            throw new ConfigurationException(error, e);
        }
    }

    private TypeFactory getXMLTypeFactory() throws Exception {
        if (null != this.m_xmlTypeFactory) {
            return this.m_xmlTypeFactory;
        }
        String message = REZ.getString("builder.missing-xml-creator.error");
        throw new Exception(message);
    }

    private static TypeFactory createxmlTypeFactory() {
        XMLTypeCreator xmlTypeFactory = null;
        try {
            xmlTypeFactory = new XMLTypeCreator();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlTypeFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

